package com.xebialabs.deployit.steps;

import java.io.File;
import java.util.HashMap;
import java.util.Map;

import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.StepExecutionContextCallbackHandler;
import com.xebialabs.deployit.ci.Database;
import com.xebialabs.deployit.ci.artifact.SqlScript;
import com.xebialabs.deployit.exception.RuntimeIOException;
import com.xebialabs.deployit.hostsession.CommandExecutionCallbackHandler;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.util.TemplateResolver;

@SuppressWarnings("serial")
public class RunSqlScriptOnDatabaseStep implements Step {
	
	private Database client;
	private SqlScript script;
	
	protected String description;
	
	public RunSqlScriptOnDatabaseStep (Database client, SqlScript script) {
		this.client = client;
		this.script = script;
		this.description = "Running SQL script " + script.getLabel() + " on SQL database " + client.getLabel();
	}

	public boolean execute(StepExecutionContext ctx) {
		HostSession s = client.getHost().getHostSession();
		try {
			CommandExecutionCallbackHandler handler = new StepExecutionContextCallbackHandler(ctx);
			
			String scriptPath = s.copyToTemporaryFile(new File(script.getLocation())).getPath(); // content e.g. select count(*) from CI_HANDLE;
			// this works: ./bin/sqlplus ad/ad@ORCL < testje.sql after running ". root.sh" when you are in dir. /home/centos/oracle/product/10.2.0/db_5
			String command = client.getCommand();
			String unresolvedOptions = client.getOptions();
			Map<String, String> variables = new HashMap<String, String>();
			variables.put("user", client.getUser());
			variables.put("password", client.getPassword());
			variables.put("database", client.getDatabase());
			TemplateResolver resolver = new TemplateResolver(variables);
			String resolvedOptions = resolver.resolveLenient(unresolvedOptions);
			
			return s.execute(handler, command, resolvedOptions, scriptPath) == 0;

		} catch (RuntimeIOException exc) {
			throw new RuntimeIOException("Cannot execute remote command \"" + client.getCommand() + "\" on " + client.getHost(), exc);
		}
	}

	public String getDescription() {
		return description;
	}

}
