package com.xebialabs.deployit.step;

import java.io.FileOutputStream;

import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.ci.Host;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostFileUtils;
import com.xebialabs.deployit.hostsession.HostSession;

@SuppressWarnings("serial")
public class HostConnectionStep implements Step {
	
	protected final Host host;

	public HostConnectionStep(Host host) {
		this.host = host;
	}

	public boolean execute(StepExecutionContext ctx) {
		HostSession rhs = host.getHostSession();
		try {
			HostFile uploadTestFile = uploadTestFile(rhs);
			ctx.logOutput("Copy of " + uploadTestFile + " to host " + this.host + " succeeded");
		} finally {
			rhs.close();
		}
		return true;
	}

	public String getDescription() {
		return "Testing connection to " + host;
	}

	private HostFile uploadTestFile(HostSession rhs) {
		HostFile updloadedTestFile = null;
		HostSession lhs = Host.getLocalHost().getHostSession();
		HostFile tempFile = lhs.getTempFile("hostconnection-local", ".txt");
		try {
			FileOutputStream fos = new FileOutputStream(tempFile.getPath());
			try {
				fos.write("DEPLOYIT".getBytes());
			} finally {
				fos.close();
			}

			updloadedTestFile = rhs.getTempFile("hostconnection-remote", ".txt");
			HostFileUtils.copy(tempFile, updloadedTestFile);
		} catch (Exception e) {
			throw new RuntimeException("upload test file failed", e);
		} finally {
			lhs.close();
		}
		return updloadedTestFile;
	}

}
