package com.xebialabs.deployit.runbook;

import java.util.List;

import com.xebialabs.deployit.Change;
import com.xebialabs.deployit.ChangePlan;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.ci.Host;
import com.xebialabs.deployit.step.HostConnectionStep;
import com.xebialabs.deployit.util.SingleTypeHandlingRunBook;

public class HostConnectionRunbook extends SingleTypeHandlingRunBook<Host> {

	public HostConnectionRunbook() {
		super(Host.class);
	}
	
	@Override
	protected void resolve(Change<Host> change, ChangePlan changePlan, List<Step> steps) {
		if (change.isAddition() || change.isModification()) {
			steps.add(new HostConnectionStep(change.getNewRevision()));
		}
	}

}
