package com.xebialabs.deployit.hostsession;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;

import com.xebialabs.deployit.util.TemplateResolver;

public class LenientTemplateResolvingHostFileInputTransformer implements	HostFileInputStreamTransformer {
	
	private TemplateResolver resolver;
	
	public LenientTemplateResolvingHostFileInputTransformer(Map<String, String> properties) {
		this.resolver = new TemplateResolver(properties);
	}

	public InputStream transform(HostFile input) {
		String inputFileAsString = HostFileUtils.getHostFileAsString(input);
		
		String resolvedFileAsString = resolver.resolveLenient(inputFileAsString);
		return new ByteArrayInputStream(resolvedFileAsString.getBytes());
	}

}
