/*
 * Copyright (c) 2010 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to  (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import com.xebialabs.deployit.reflect.ConfigurationItemReflectionUtils;

/**
 * Specifies that this field is part of the configuration item. It will be injected with the correct value to be read
 * from runbooks.
 */
@Documented
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.FIELD)
public @interface ConfigurationItemProperty {

	/**
	 * The category of this property. In the user interface all the properties belonging to the same category will be
	 * grouped together.
	 */
	String category() default "Common";

	/**
	 * The descriptive label of this property as it should be shown in the user interface. If no label is not specified,
	 * the name of the field is used. Camel case in the field name is replaced by spaces and the first character is
	 * capitalized, e.g. "classLoaderPolicy" is transformed into "Class loader policy".
	 */
	String label() default "";

	/**
	 * The description of this property as it should be shown in the user interface. If no description is specified, the
	 * label is used.
	 */
	String description() default "";

	/**
	 * Whether this property is required.
	 */
	boolean required() default false;
	
	/**
	 * Whether this property is editable by the user.
	 */
	boolean editable() default true;

	/**
	 * Whether this property is a password property. If <tt>true</tt> this field will be masked in the user interface.
	 */
	boolean password() default false;

	/**
	 * Whether this property should be considered when comparing this CI to another CI to check if they are
	 * {@link ConfigurationItemReflectionUtils#isSimilar(java.io.Serializable, java.io.Serializable) similar}.
	 */
	boolean identifying() default false;

	/**
	 * The size of this property as it should be shown in the user interface.
	 */
	Size size() default Size.DEFAULT;

	/**
	 * Defines a number of standard sizes for configuration item properties.
	 */
	public static enum Size {
		/**
		 * Defines that the configuration item property should be shown using the default size.
		 */
		DEFAULT,

		/**
		 * Defines that the configuration item property should be shown using the small size.
		 */
		SMALL,

		/**
		 * Defines that the configuration item property should be shown using the medium size.
		 */
		MEDIUM,

		/**
		 * Defines that the configuration item property should be shown using the large size.
		 */
		LARGE
	}

}
