/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.steps;

import com.google.common.base.Preconditions;
import com.xebialabs.deployit.exception.RuntimeIOException;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostFileUtils;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.util.TemplateResolver;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.springframework.core.io.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PlaceholderReplacingHostFile
implements HostFile {
    private final HostFile decoratedHostFile;
    private final TemplateResolver templateResolver;
    private final boolean lenientResolution;
    private final String resolvedTemplate;

    public PlaceholderReplacingHostFile(HostFile decoratedHostFile, TemplateResolver templateResolver) {
        this(decoratedHostFile, templateResolver, false);
    }

    public PlaceholderReplacingHostFile(HostFile decoratedHostFile, TemplateResolver templateResolver, boolean lenientResolution) {
        this.decoratedHostFile = (HostFile)Preconditions.checkNotNull((Object)decoratedHostFile);
        Preconditions.checkArgument((!decoratedHostFile.isDirectory() ? 1 : 0) != 0, (Object)"Placeholder replacement is only supported on files");
        this.templateResolver = (TemplateResolver)Preconditions.checkNotNull((Object)templateResolver);
        this.lenientResolution = lenientResolution;
        this.resolvedTemplate = this.resolveTemplate();
    }

    @Override
    public boolean canExecute() throws RuntimeIOException {
        return this.decoratedHostFile.canExecute();
    }

    @Override
    public boolean canRead() throws RuntimeIOException {
        return this.decoratedHostFile.canRead();
    }

    @Override
    public boolean canWrite() throws RuntimeIOException {
        return this.decoratedHostFile.canWrite();
    }

    @Override
    public boolean delete() throws RuntimeIOException {
        return this.decoratedHostFile.delete();
    }

    @Override
    public boolean deleteRecursively() throws RuntimeIOException {
        return this.decoratedHostFile.deleteRecursively();
    }

    @Override
    public boolean deleteRecursively(String exclusion) throws RuntimeIOException {
        return this.decoratedHostFile.deleteRecursively(exclusion);
    }

    @Override
    public boolean exists() throws RuntimeIOException {
        return this.decoratedHostFile.exists();
    }

    @Override
    public InputStream get() throws RuntimeIOException {
        return new ByteArrayInputStream(this.resolvedTemplate.getBytes());
    }

    private String resolveTemplate() {
        String template = HostFileUtils.getHostFileAsString(this.decoratedHostFile);
        assert (template != null);
        String resolved = this.lenientResolution ? this.templateResolver.resolveLenient(template) : this.templateResolver.resolveStrict(template);
        return resolved;
    }

    @Override
    public void get(OutputStream out) throws RuntimeIOException {
        this.decoratedHostFile.get(out);
    }

    @Override
    public void get(File file) throws RuntimeIOException {
        this.decoratedHostFile.get(file);
    }

    @Override
    public HostFile getFile(String name) throws RuntimeIOException {
        return this.decoratedHostFile.getFile(name);
    }

    @Override
    public String getName() {
        return this.decoratedHostFile.getName();
    }

    @Override
    public String getParent() {
        return this.decoratedHostFile.getParent();
    }

    @Override
    public HostFile getParentFile() {
        return this.decoratedHostFile.getParentFile();
    }

    @Override
    public String getPath() {
        return this.decoratedHostFile.getPath();
    }

    @Override
    public HostSession getSession() {
        return this.decoratedHostFile.getSession();
    }

    @Override
    public boolean isDirectory() throws RuntimeIOException {
        return this.decoratedHostFile.isDirectory();
    }

    @Override
    public long length() throws RuntimeIOException {
        return this.resolvedTemplate.length();
    }

    @Override
    public List<String> list() throws RuntimeIOException {
        return this.decoratedHostFile.list();
    }

    @Override
    public List<HostFile> listFiles() throws RuntimeIOException {
        return this.decoratedHostFile.listFiles();
    }

    @Override
    public void mkdir() throws RuntimeIOException {
        this.decoratedHostFile.mkdir();
    }

    @Override
    public void mkdirs() throws RuntimeIOException {
        this.decoratedHostFile.mkdirs();
    }

    @Override
    public OutputStream put(long length) throws RuntimeIOException {
        return this.decoratedHostFile.put(length);
    }

    @Override
    public void put(InputStream in, long length) throws RuntimeIOException {
        this.decoratedHostFile.put(in, length);
    }

    @Override
    public void put(File file) throws RuntimeIOException {
        this.decoratedHostFile.put(file);
    }

    @Override
    public void put(Resource resource) throws RuntimeIOException {
        this.decoratedHostFile.put(resource);
    }

    public String toString() {
        return this.decoratedHostFile + " (decorated)";
    }
}

