/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.hostsession.ssh;

import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.xebialabs.deployit.exception.RuntimeIOException;
import com.xebialabs.deployit.hostsession.ssh.SshHostSession;
import com.xebialabs.deployit.hostsession.ssh.SshScpHostFile;
import com.xebialabs.deployit.hostsession.ssh.SshStreamUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

class SshScpOutputStream
extends OutputStream {
    protected SshScpHostFile file;
    protected long length;
    protected String command;
    protected Session session;
    protected ChannelExec channel;
    protected InputStream channelIn;
    protected OutputStream channelOut;
    private static final String CHANNEL_PURPOSE = " (for SCP input stream)";
    private Logger logger = Logger.getLogger(SshScpOutputStream.class);

    SshScpOutputStream(SshScpHostFile file, long length) {
        this.file = file;
        this.length = length;
    }

    void open() {
        try {
            this.session = this.file.sshHostSession.openSession(CHANNEL_PURPOSE);
            this.channel = (ChannelExec)this.session.openChannel("exec");
            this.command = SshHostSession.encodeCommandLine(false, "scp", "-t", this.file.remotePath);
            this.channel.setCommand(this.command);
            this.channelIn = this.channel.getInputStream();
            this.channelOut = this.channel.getOutputStream();
            this.channel.connect();
            this.logger.info((Object)("Executing remote command \"" + this.command + "\" on " + this.file.sshHostSession + " to open SCP stream for writing"));
            this.readAck();
            this.sendFilePreamble();
            this.logger.info((Object)("Opened SCP stream to write to remote file " + this.file));
        }
        catch (IOException exc) {
            throw new RuntimeIOException("Cannot open SCP stream to write remote file " + this.file, exc);
        }
        catch (JSchException exc) {
            throw new RuntimeIOException("Cannot open SCP stream to write remote file " + this.file, exc);
        }
    }

    private void readAck() {
        int c;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Reading ACK");
        }
        if ((c = SshStreamUtils.checkAck(this.channelIn)) != 0) {
            throw new RuntimeIOException("Protocol error on SCP stream to write remote file " + this.file);
        }
    }

    private void sendFilePreamble() throws IOException {
        String preamble = "C0644 " + this.length + " ";
        preamble = this.file.remotePath.lastIndexOf(47) > 0 ? preamble + this.file.remotePath.substring(this.file.remotePath.lastIndexOf(47) + 1) : preamble + this.file.remotePath;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Sending file preamble \"" + preamble + "\""));
        }
        preamble = preamble + "\n";
        this.channelOut.write(preamble.getBytes());
        this.channelOut.flush();
    }

    private void sendAck() throws IOException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Sending ACK");
        }
        this.channelOut.write(0);
        this.channelOut.flush();
    }

    public void write(byte[] b) throws IOException {
        this.channelOut.write(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.channelOut.write(b, off, len);
    }

    public void write(int b) throws IOException {
        this.channelOut.write(b);
    }

    public void close() {
        try {
            this.sendAck();
            this.readAck();
        }
        catch (IOException ignore) {
            // empty catch block
        }
        IOUtils.closeQuietly((OutputStream)this.channelOut);
        int res = SshHostSession.waitForExitStatus(this.channel);
        IOUtils.closeQuietly((InputStream)this.channelIn);
        this.channel.disconnect();
        this.file.sshHostSession.disconnectSession(this.session, CHANNEL_PURPOSE);
        if (res != 0) {
            throw new RuntimeIOException("Error closing SCP stream to write remote file " + this.file + " (remote scp command returned error code " + res + ")");
        }
    }
}

