/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.hostsession.ssh;

import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import com.xebialabs.deployit.ci.OperatingSystemFamily;
import com.xebialabs.deployit.exception.RuntimeIOException;
import com.xebialabs.deployit.hostsession.CommandExecutionCallbackHandler;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.hostsession.common.AbstractHostSession;
import com.xebialabs.deployit.hostsession.common.ErrorStreamToCallbackHandler;
import com.xebialabs.deployit.hostsession.common.InputResponseHandler;
import com.xebialabs.deployit.hostsession.common.OutputStreamToCallbackHandler;
import com.xebialabs.deployit.hostsession.ssh.SshHostFile;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Map;
import java.util.Random;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class SshHostSession
extends AbstractHostSession
implements HostSession {
    protected String host;
    protected int port;
    protected String username;
    protected String password;
    protected Session sharedSession;
    private static final String CHANNEL_PURPOSE = "";
    private static Logger logger = Logger.getLogger(SshHostSession.class);

    public SshHostSession(OperatingSystemFamily os, String temporaryDirectoryPath, String host, int port, String username, String password) {
        super(os, temporaryDirectoryPath);
        this.host = host;
        this.port = port;
        this.username = username;
        this.password = password;
    }

    void open() throws RuntimeIOException {
        if (this.sharedSession == null) {
            try {
                this.sharedSession = this.openSession(CHANNEL_PURPOSE);
            }
            catch (JSchException exc) {
                throw new RuntimeIOException("Cannot connect to " + this, exc);
            }
        }
    }

    @Override
    public void close() {
        super.close();
        this.disconnectSharedSession();
    }

    protected Session getSharedSession() {
        if (this.sharedSession == null) {
            throw new IllegalStateException("Not connected");
        }
        return this.sharedSession;
    }

    public void disconnectSharedSession() {
        this.disconnectSession(this.sharedSession, CHANNEL_PURPOSE);
        this.sharedSession = null;
    }

    protected Session openSession(String purpose) throws JSchException {
        JSch jsch = new JSch();
        Session session = jsch.getSession(this.username, this.host, this.port);
        session.setUserInfo(this.getUserInfo());
        session.connect();
        logger.info((Object)("Connected to " + this + purpose));
        return session;
    }

    protected void disconnectSession(Session session, String purpose) {
        if (session != null) {
            session.disconnect();
            logger.info((Object)("Disconnected from " + this + purpose));
        }
    }

    @Override
    public HostFile getFile(String hostPath) throws RuntimeIOException {
        return this.getFile(hostPath, false);
    }

    protected abstract HostFile getFile(String var1, boolean var2) throws RuntimeIOException;

    @Override
    public HostFile getFile(HostFile parent, String child) throws RuntimeIOException {
        if (!(parent instanceof SshHostFile)) {
            throw new IllegalStateException("parent is not a file on an SSH host");
        }
        if (parent.getSession() != this) {
            throw new IllegalStateException("parent is not a file in this session");
        }
        return this.getFile(parent.getPath() + this.getHostOperatingSystem().getFileSeparator() + child);
    }

    @Override
    public HostFile getTempFile(String prefix, String suffix) throws RuntimeIOException {
        if (suffix == null) {
            suffix = ".tmp";
        }
        Random r = new Random();
        String infix = CHANNEL_PURPOSE;
        int i = 0;
        while ((long)i < 100L) {
            HostFile f = this.getFile(this.getTemporaryDirectory().getPath() + this.getHostOperatingSystem().getFileSeparator() + prefix + infix + suffix, true);
            if (!f.exists()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Created temporary file " + f));
                }
                return f;
            }
            infix = "-" + Long.toString(Math.abs(r.nextLong()));
            ++i;
        }
        throw new RuntimeIOException("Cannot generate a unique temporary file name on " + this);
    }

    @Override
    public int execute(CommandExecutionCallbackHandler handler, String ... commandLine) throws RuntimeIOException {
        return this.execute(handler, Collections.EMPTY_MAP, commandLine);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int execute(CommandExecutionCallbackHandler handler, Map<String, String> inputResponse, String ... commandLine) throws RuntimeIOException {
        int n;
        String command = SshHostSession.encodeCommandLine(false, commandLine);
        String commandWithHiddenPassword = SshHostSession.encodeCommandLine(true, commandLine);
        ChannelExec channel = (ChannelExec)this.getSharedSession().openChannel("exec");
        channel.setPty(true);
        Thread outputCopierThread = null;
        Thread errorCopierThread = null;
        try {
            channel.setCommand(command);
            InputStream remoteStdout = channel.getInputStream();
            InputStream remoteStderr = channel.getErrStream();
            OutputStream remoteStdin = channel.getOutputStream();
            InputResponseHandler responseHandler = new InputResponseHandler(handler, remoteStdin, inputResponse);
            outputCopierThread = new Thread(new OutputStreamToCallbackHandler(remoteStdout, responseHandler));
            outputCopierThread.start();
            errorCopierThread = new Thread(new ErrorStreamToCallbackHandler(remoteStderr, responseHandler));
            errorCopierThread.start();
            channel.connect();
            logger.info((Object)("Executing remote command \"" + commandWithHiddenPassword + "\" on " + this));
            n = SshHostSession.waitForExitStatus(channel);
        }
        catch (Throwable throwable) {
            try {
                channel.disconnect();
                if (outputCopierThread != null) {
                    try {
                        outputCopierThread.join();
                    }
                    catch (InterruptedException ignored) {
                        // empty catch block
                    }
                }
                if (errorCopierThread != null) {
                    try {
                        errorCopierThread.join();
                    }
                    catch (InterruptedException ignored) {
                        // empty catch block
                    }
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Finished executing remote command \"" + commandWithHiddenPassword + "\" on " + this));
                }
                throw throwable;
            }
            catch (IOException exc) {
                throw new RuntimeIOException("Cannot execute remote command \"" + commandWithHiddenPassword + "\" on " + this, exc);
            }
            catch (JSchException exc) {
                throw new RuntimeIOException("Cannot execute remote command \"" + commandWithHiddenPassword + "\" on " + this, exc);
            }
        }
        channel.disconnect();
        if (outputCopierThread != null) {
            try {
                outputCopierThread.join();
            }
            catch (InterruptedException ignored) {
                // empty catch block
            }
        }
        if (errorCopierThread != null) {
            try {
                errorCopierThread.join();
            }
            catch (InterruptedException ignored) {
                // empty catch block
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Finished executing remote command \"" + commandWithHiddenPassword + "\" on " + this));
        }
        return n;
    }

    static int waitForExitStatus(ChannelExec channel) {
        while (!channel.isClosed()) {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
            }
        }
        return channel.getExitStatus();
    }

    protected UserInfo getUserInfo() {
        return new UserInfo(){

            public boolean promptPassword(String prompt) {
                return true;
            }

            public String getPassword() {
                return SshHostSession.this.password;
            }

            public boolean promptPassphrase(String prompt) {
                return false;
            }

            public String getPassphrase() {
                return null;
            }

            public boolean promptYesNo(String prompt) {
                return true;
            }

            public void showMessage(String msg) {
                logger.info((Object)("Message recieved while connecting to " + SshHostSession.this.username + "@" + SshHostSession.this.host + ":" + SshHostSession.this.port + ": " + msg));
            }
        };
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public static String encodeCommandLine(boolean hidePassword, String ... commandLine) {
        if (commandLine == null || commandLine.length == 0) {
            throw new IllegalStateException("Cannot execute an empty command line");
        }
        StringBuilder sb = new StringBuilder();
        boolean passwordKeywordSeen = false;
        for (int i = 0; i < commandLine.length; ++i) {
            int j;
            if (i != 0) {
                sb.append(' ');
            }
            if (commandLine[i] == null) {
                sb.append("null");
                continue;
            }
            if (commandLine[i].length() == 0) {
                sb.append("\" \"");
                continue;
            }
            if (passwordKeywordSeen && hidePassword) {
                for (j = 0; j < commandLine[i].length(); ++j) {
                    sb.append("*");
                }
            } else {
                for (j = 0; j < commandLine[i].length(); ++j) {
                    char c = commandLine[i].charAt(j);
                    if (" '\"\\;()${}".indexOf(c) != -1) {
                        sb.append('\\');
                    }
                    sb.append(c);
                }
            }
            passwordKeywordSeen = StringUtils.endsWithIgnoreCase((String)commandLine[i], (String)"password");
        }
        return sb.toString();
    }

    public String toString() {
        return this.username + "@" + this.host + ":" + this.port;
    }
}

