/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.ci.security;

import com.xebialabs.deployit.BaseConfigurationItem;
import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;
import com.xebialabs.deployit.ci.security.AccessControlEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ConfigurationItem(description="A permission scheme to apply to a configuration item.", category="permission schemes")
public class PermissionScheme
extends BaseConfigurationItem {
    @ConfigurationItemProperty(required=true, description="Access control entries.")
    private List<AccessControlEntry> accessControlEntries = new ArrayList<AccessControlEntry>();
    @ConfigurationItemProperty(required=false, description="Allowed CI types.")
    private Set<String> allowedCiTypes = new HashSet<String>();

    public AccessControlEntry getApplicablePermissions(String username, Collection<String> groupNames) {
        AccessControlEntry mergedAclEntry = AccessControlEntry.getNoPermissions(username);
        for (AccessControlEntry each : this.getAccessControlEntries()) {
            if (!groupNames.contains(each.getGroupName())) continue;
            mergedAclEntry.merge(each);
        }
        return mergedAclEntry;
    }

    public List<AccessControlEntry> getAccessControlEntries() {
        return this.accessControlEntries;
    }

    public void setAccessControlEntries(List<AccessControlEntry> accessControlEntries) {
        this.accessControlEntries = accessControlEntries == null ? new ArrayList<AccessControlEntry>() : accessControlEntries;
    }

    public Set<String> getAllowedCiTypes() {
        return this.allowedCiTypes;
    }

    public void setAllowedCiTypes(Set<String> allowedCiTypes) {
        this.allowedCiTypes = allowedCiTypes;
    }
}

