/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.ci;

import com.xebialabs.deployit.exception.RuntimeIOException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum OperatingSystemFamily {
    WINDOWS,
    UNIX;


    public String getScriptExtension() {
        if (this == WINDOWS) {
            return ".bat";
        }
        return ".sh";
    }

    public String getLineSeparator() {
        if (this == WINDOWS) {
            return "\r\n";
        }
        return "\n";
    }

    public String getDefaultTemporaryDirectoryPath() {
        if (this == WINDOWS) {
            return "C:\\temp";
        }
        return "/tmp";
    }

    public String getFileSeparator() {
        if (this == WINDOWS) {
            return "\\";
        }
        return "/";
    }

    public String getPathSeparator() {
        if (this == WINDOWS) {
            return ";";
        }
        return ":";
    }

    public String convertText(String text) {
        if (text == null) {
            return null;
        }
        String lineSep = this.getLineSeparator();
        try {
            String line;
            StringBuilder converted = new StringBuilder();
            BufferedReader r = new BufferedReader(new StringReader(text));
            while ((line = r.readLine()) != null) {
                converted.append(line).append(lineSep);
            }
            return converted.toString();
        }
        catch (IOException exc) {
            throw new RuntimeIOException("Unable to read String", exc);
        }
    }
}

