/*
 * Copyright (c) 2010 XebiaLabs B.V. All rights reserved.
 *
 * Your use of Xebialabs Software and Documentation is subject to the Personal
 * License Agreement.
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * ‚ÄúDocumentation‚Äù means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the Xebialabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to  (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

/**
 * The mapper framework; a way to modularize runbooks.
 * 
 * The mapper framework helps runbooks to generate mappings based on the mappings available in the {@link com.xebialabs.deployit.ci.Deployment} CI.
 * In short to get/create mappings, first define your own mapper like;<br>
 * 
 * <code><pre>
 * public class MyMapper extends Mapper&lt;Ear, MyMapping, Server&gt; {
 *      public MyMapper(Change&lt;Deployment&gt; change) {
 *         super(change);
 *      }
 * }
 * </code></pre>
 * This will create a mapper where you can ask it for <strong>added, modified or deleted</strong> mappings.
 * <br>
 * This is useful when trying to figure out where each {@link com.xebialabs.deployit.ci.artifact.DeployableArtifact} should be deployed to.
 * It also retrieves from the <i>Deployment-change</i> any mappings of a specific type (in the example above of type <code>MyMapping</code>) 
 * that a user added to the deployment, overrides properties and detects if mappings are similar or identical.
 * 
 * <h3>Runbook code</h3>
 * To create a mapper in the runbook and get its mappings;
 * <code><pre>
 * MyMapper mapper = new MyMapper(change);
 * List&lt;MyMapping&gt; addedMappings = mapper.getAddedMappings();
 * List&lt;MyMapping&gt; modifiedMappings = mapper.getModifiedMappings();
 * List&lt;MyMapping&gt; deletedMappings = mapper.getDeletedMappings();
 * </pre></code>
 * 
 * @version 1.2
 */
package com.xebialabs.deployit.mapper;

