/*
 * Copyright (c) 2010 XebiaLabs B.V. All rights reserved.
 *
 * Your use of Xebialabs Software and Documentation is subject to the Personal
 * License Agreement.
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * ‚ÄúDocumentation‚Äù means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the Xebialabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to  (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.mapper;

import java.io.Serializable;

/**
 * A pair of objects.
 * 
 * @param <X>
 *            the type of the first element of the pair.
 * @param <Y>
 *            the type of the second element of the pair.
 */
@SuppressWarnings("serial")
public class Pair<X, Y> implements Serializable {

	private X first;

	private Y second;

	/**
	 * Creates a <tt>Pair</tt> with the specified elements.
	 * 
	 * @param first
	 *            the first element
	 * @param second
	 *            the second element
	 */
	public Pair(X first, Y second) {
		this.first = first;
		this.second = second;
	}

	/**
	 * Returns the first element.
	 * 
	 * @return the first element
	 */
	public X getFirst() {
		return first;
	}

	/**
	 * Set the first element of the pair.
	 * 
	 * @param first
	 *            the first element
	 */
	public void setFirst(X first) {
		this.first = first;
	}

	/**
	 * Returns the second element.
	 * 
	 * @return the second element
	 */
	public Y getSecond() {
		return second;
	}

	/**
	 * Set the second element of the pair.
	 * 
	 * @param second
	 *            the second element
	 */
	public void setSecond(Y second) {
		this.second = second;
	}

}