/*
 * Copyright (c) 2010 XebiaLabs B.V. All rights reserved.
 *
 * Your use of Xebialabs Software and Documentation is subject to the Personal
 * License Agreement.
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * ‚ÄúDocumentation‚Äù means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the Xebialabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to  (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.ci.security;

import java.io.Serializable;

import com.xebialabs.deployit.ConfigurationItemProperty;

/**
 * An access control entry on a {@link PermissionScheme}.
 */
@SuppressWarnings("serial")
public class AccessControlEntry implements Serializable {

	@ConfigurationItemProperty(label = "Group name", description = "Name of the group ")
	private String groupName;

	@ConfigurationItemProperty
	private boolean canView;

	@ConfigurationItemProperty
	private boolean canModify;

	@ConfigurationItemProperty
	private boolean canRedeploy;

	public AccessControlEntry() {
		// no-op
	}

	public AccessControlEntry(String groupName, boolean view, boolean modify, boolean redeploy, boolean addtogroup) {
		this.groupName = groupName;
		this.canView = view;
		this.canModify = modify;
		this.canRedeploy = redeploy;
	}

	public static AccessControlEntry getNoPermissions(String groupName) {
		return new AccessControlEntry(groupName, false, false, false, false);
	}

	public static AccessControlEntry getAllPermissions(String groupName) {
		return new AccessControlEntry(groupName, true, true, true, true);
	}

	@Override
	public String toString() {
		StringBuffer b = new StringBuffer();
		b.append("[");
		b.append("groupname=");
		b.append(getGroupName());
		b.append(" canview=");
		b.append(canView ? "true" : "false");
		b.append(" canmodify=");
		b.append(canModify ? "true" : "false");
		b.append(" canredeploy=");
		b.append(canRedeploy ? "true" : "false");
		b.append(" canaddtogroup=");
		b.append("]");
		return b.toString();
	}

	public void merge(AccessControlEntry aclEntryToMerge) {
		canView = canView || aclEntryToMerge.isCanView();
		canModify = canModify || aclEntryToMerge.isCanModify();
		canRedeploy = canRedeploy || aclEntryToMerge.isCanRedeploy();
	}

	public String getGroupName() {
		return groupName;
	}

	public void setGroupName(String groupName) {
		this.groupName = groupName;
	}

	public boolean isCanView() {
		return canView;
	}

	public void setCanView(boolean canView) {
		this.canView = canView;
	}

	public boolean isCanModify() {
		return canModify;
	}

	public void setCanModify(boolean canModify) {
		this.canModify = canModify;
	}

	public boolean isCanRedeploy() {
		return canRedeploy;
	}

	public void setCanRedeploy(boolean canRedeploy) {
		this.canRedeploy = canRedeploy;
	}
}
