/*
 * Copyright (c) 2010 XebiaLabs B.V. All rights reserved.
 *
 * Your use of Xebialabs Software and Documentation is subject to the Personal
 * License Agreement.
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * ‚ÄúDocumentation‚Äù means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the Xebialabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to  (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

/**
 * <h2>{@link com.xebialabs.deployit.ci.mapping.Mapping Mappings} allow a user to add detailed deployment information to a {@link com.xebialabs.deployit.ci.Deployment Deployment CI}</h2>
 * 
 * When deploying a {@link com.xebialabs.deployit.ci.DeploymentPackage Deployment Package} to 
 * an {@link com.xebialabs.deployit.ci.Environment Environment}
 * with a {@link com.xebialabs.deployit.ci.Deployment Deployment} you sometimes need to be more precise which artifact in the 
 * {@link com.xebialabs.deployit.ci.DeploymentPackage Deployment Package} should go to which member of an {@link com.xebialabs.deployit.ci.Environment Environment}.
 * Also differences between environments need different settings and/or actions during the deployment of applications/packages.
 * Database settings for example differ for several environments, hostnames, usernames and password are likely to be different.
 * Mappings and Mappers can handle the logic to perform different actions and change settings according to the environment.
 * 
 * Mappings even allow you to override properties of artifacts of a Deployment Package with 
 * the {@link com.xebialabs.deployit.ci.mapping.SourcePropertyOverridingMapping}.
 * 
 * <h3>As an example</h3>
 * 
 * <h4>Lets say you have the following deployment package named "MyApplication"</h4>
 * <ul>
 * <li>Ear file named "frontend" which contains the main Application</li>
 * <li>Ear file named "admin" which contains the administration part of the application</li>
 * <li>Datasource named "myApplication_ds" which is used by the "frontend" and "admin" ears/applications</li>
 * <li>Datasource named "remoteSystem_ds" which is used only by the "frontend" ear/application</li>
 * </ul>
 * 
 * <h4>The environment named "prod_env" where you will deploy the "MyApplication" deployment package to, contains</h4>
 * <ul>
 * <li>Application Server Cluster named "frontend_cluster_1"</li>
 * <li>Application Server Cluster named "frontend_cluster_2"</li>
 * <li>1 Application Server named "admin_server"</li>
 * </ul>
 * 
 * You want to deploy the "frontend" ear to "frontend_cluster_1" and to "frontend_cluster_2". The "admin" ear should only go to the "admin_server".
 * The "frontend" application is used by more then 10.000 users so therefore it should run on 2 clusters, while the "admin" application is only used by 5 people
 * and should only be accessible from the company network. Therefore it has been decided to split the administration part of the application of the "frontend" part.
 * 
 * By using mappings, deployit allows a user to specify which ear should go where.
 * 
 * <h4>In the example case it would mean, create a deployment ci, source="MyApplication", target="prod_env" with 3 mappings</h4>
 * <ul>
 * <li>EarMapping source="frontend", target="frontend_cluster_1"</li>
 * <li>EarMapping source="frontend", target="frontend_cluster_2"</li>
 * <li>EarMapping source="admin", target="admin_server"</li>
 * </ul>
 * 
 * The runbook which then will trigger, can get the mappings from the deployment ci and know where the individual ears should be deployed on.
 * 
 * <h3>Overriding properties</h3>
 * In the above example there are also 2 datasources in the deployment package, named "myApplication_ds" and "remoteSystem_ds".
 * When deploying these 2 datasources to the environment you might want to specify the location of the database, username and password, 
 * because in most environments these properties differ. For example; the datasource in the test environment points to a different database 
 * then the datasource in the production environment while some properties, like JNDI name remain the same.
 * 
 * <h4>SourcePropertyOverridingMapping</h4>
 * Deployit allows to override properties from a ci which is in the Deployment Package by using the {@link com.xebialabs.deployit.ci.mapping.SourcePropertyOverridingMapping}.
 * You specify the source of a mapping and the target and add key value pairs for every property you want to override of that ci.
 * 
 * <h4>Overriding example</h4>
 * To override the location, username and password properties of the 2 datasources you create a SourcePropertyOverridingMapping mappings. (always a subclass)
 * <ul>
 * <li>DatasourceMapping (subclass of SourcePropertyOverridingMapping), source="myApplication_ds", target="frontend_cluster_1" and contains the following key value pairs
 * 	<ul>
 * 	<li>key=location, value=proddb.mycompany.com:2001</li>
 * 	<li>key=username, value=produser</li>
 * 	<li>key=password, value=averysecretp[roductionpassword</li>
 * 	</ul>
 * </li>
 * </ul>
 * The runbook can ask the SourcePropertyOverridingMapping for its source and the key, value pairs will be overlayed onto the properties of the source ci.
 *
 * <h3>Optimizing the deployment (isSimilar, isIdentical)</h3>
 * Sometimes when upgrading a deployment package to an environment, certain artifacts in the deployment package are the same.
 * Deployit offers support to find out if certain mappings are identical (All properties are the same, nothing to do) 
 * or if they are similar (Identifying properties are the same but some properties are different).
 * 
 * <h4>isIdentical</h4>
 * When 2 mappings are identical, that usually means, a runbook does not need to create steps.
 *
 * <h4>isSimilar</h4>
 * When 2 mappings are similar, that usually means, a runbook only needs to create modify steps.
 * Example; change the username of a datasource
 * 
 * <h4>When NOT isSimilar or isIdentical</h4>
 * Then the runbook needs to create <i>destroy and create</i> steps.
 * 
 * <h3>Using the mappings in your runbook</h3>
 * <code>
 * Deployment newDeployment = deploymentChange.getNewRevision();<br>
 * List<EarMapping> earMappings = newDeployment.getMappingsOfType(EarMapping.class);<br>
 * Ear ear = earMapping.getSource();<br>
 * Server server = earMapping.getTarget();<br>
 * addStep(new DeployEarToServer(ear, server));<br>
 * </code>
 * 
 * <h3>Using default mappings in your runbook</h3>
 * Deployit also offers a way to generate mappings for runbooks, see the {@link com.xebialabs.deployit.mapper} package.
 * @version 1.2
 */
package com.xebialabs.deployit.ci.mapping;

