/*
 * Copyright (c) 2010 XebiaLabs B.V. All rights reserved.
 *
 * Your use of Xebialabs Software and Documentation is subject to the Personal
 * License Agreement.
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * ‚ÄúDocumentation‚Äù means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the Xebialabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to  (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.steps;

import java.util.Map;

import org.apache.log4j.Logger;

import com.xebialabs.deployit.ResolutionException;
import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.ci.Host;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostFileUtils;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.hostsession.HostSessionFactory;
import com.xebialabs.deployit.util.TemplateResolver;

/**
 * @deprecated Use {@link CopyStep#CopyStep(Host, String, Host, String, boolean, Map)} instead.
 */
@SuppressWarnings("serial")
public class PlaceholderReplacingCopyStep extends CopyStep {

	private static final long MAX_FILE_SIZE = 1048576;

	public PlaceholderReplacingCopyStep(Host sourceHost, String sourceLocation, Host destinationHost, String destinationLocation,
			boolean createToplevelDirectory, Map<String, String> properties) {
		super(sourceHost, sourceLocation, destinationHost, destinationLocation, createToplevelDirectory, properties);
	}

	@Override
	public boolean execute(StepExecutionContext ctx) {
		HostSession sourceSession = getHostSession();
		HostSession destinationSession = HostSessionFactory.getHostSession(destinationHost);
		try {
			HostFile sourceFile = sourceSession.getFile(sourceLocation);

			HostFile destinationFile = destinationSession.getFile(destinationLocation);

			boolean parentIsCreated = false;
			if (createToplevelDirectory && !destinationFile.exists()) {
				ctx.logOutput("Creating directory " + destinationFile);
				destinationFile.mkdirs();
				parentIsCreated = true;
			}

			resolveRecursively(sourceFile, destinationSession, ctx, destinationFile, parentIsCreated);
			return true;
		} finally {
			sourceSession.close();
			destinationSession.close();
		}
	}

	private void resolveRecursively(HostFile sourceFile, HostSession destinationSession, StepExecutionContext ctx, HostFile destinationParentDir,
			boolean parentIsCreated) {
		if (sourceFile.isDirectory()) {
			HostFile childDestinationDir;
			if (parentIsCreated) {
				childDestinationDir = destinationParentDir;
			} else {
				childDestinationDir = destinationParentDir.getFile(sourceFile.getName());
			}
			if (!childDestinationDir.exists() && !parentIsCreated) {
				ctx.logOutput("Creating directory " + childDestinationDir);
				childDestinationDir.mkdirs();
			}
			for (HostFile child : sourceFile.listFiles()) {
				resolveRecursively(child, destinationSession, ctx, childDestinationDir, false);
			}
		} else {
			HostFile resolvedSimpleFile;
			if (properties != null && !properties.isEmpty()) {
				if (sourceFile.length() > MAX_FILE_SIZE) {
					throw new ResolutionException("Cannot handle " + sourceFile.getName() + ".File too large(>" + MAX_FILE_SIZE + " bytes)");
				}
				resolvedSimpleFile = new PlaceholderReplacingHostFile(sourceFile, new TemplateResolver(properties));
				if (logger.isDebugEnabled()) {
					logger.debug("returning resolved file " + resolvedSimpleFile.getName());
				}
			} else {
				resolvedSimpleFile = sourceFile;
			}
			ctx.logOutput("Copying " + sourceFile + " to " + destinationParentDir);
			HostFileUtils.copy(resolvedSimpleFile, destinationParentDir.getFile(resolvedSimpleFile.getName()));
		}
	}

	private static Logger logger = Logger.getLogger(PlaceholderReplacingCopyStep.class);

}
