/*
 * Copyright (c) 2010 XebiaLabs B.V. All rights reserved.
 *
 * Your use of Xebialabs Software and Documentation is subject to the Personal
 * License Agreement.
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * ‚ÄúDocumentation‚Äù means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the Xebialabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to  (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit;

import java.io.Serializable;

/**
 * A changes on the repository to either add, modify or delete a configuration item.
 * 
 * @param <T>
 *            the class of the configuration item being changed.
 */
public interface Change<T extends Serializable> {

	/**
	 * The class of the CI that is being changed.
	 * 
	 * @return the class object of the CI under change.
	 */
	Class<T> getConfigurationItemClass();

	/**
	 * Returns true iff this change is an addition
	 */
	boolean isAddition();

	/**
	 * Return true iff this change is a modication.
	 */
	boolean isModification();

	/**
	 * Returns true iff this change is a deletion.
	 */
	boolean isDeletion();

	/**
	 * Returns the configuration item as it was before the change.
	 * 
	 * @return the CI before the change or <tt>null</tt> if this change is an addition.
	 */
	T getOldRevision();

	/**
	 * Returns the configuration item as it will be after the change.
	 * 
	 * @return the CI after the change or <tt>null</tt> if this change is a deletion.
	 */
	T getNewRevision();

}
