/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.deployment.planner;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.deployment.planner.DefaultDelta;
import com.xebialabs.deployit.deployment.planner.DefaultDeltaSpecification;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.DeltaSpecification;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;
import java.util.List;

public class DeltaSpecificationBuilder {
    private Operation operation = Operation.CREATE;
    private List<Delta> deltas = Lists.newArrayList();
    private DeployedApplication deployedApplication;

    public static DeltaSpecificationBuilder newSpecification() {
        return new DeltaSpecificationBuilder();
    }

    public DeltaSpecificationBuilder create(Deployed deployed) {
        return this.with(Operation.CREATE, null, deployed);
    }

    public DeltaSpecificationBuilder modify(Deployed deployed, Deployed deployed2) {
        return this.with(Operation.MODIFY, deployed, deployed2);
    }

    public DeltaSpecificationBuilder destroy(Deployed deployed) {
        return this.with(Operation.DESTROY, deployed, null);
    }

    public DeltaSpecificationBuilder noOp(Deployed deployed) {
        return this.with(Operation.NOOP, deployed, deployed);
    }

    private DeltaSpecificationBuilder with(Operation operation, Deployed deployed, Deployed deployed2) {
        this.deltas.add(new DefaultDelta(operation, deployed, deployed2));
        return this;
    }

    public DeltaSpecificationBuilder upgrade(DeployedApplication deployedApplication) {
        this.deployedApplication = deployedApplication;
        this.operation = Operation.MODIFY;
        return this;
    }

    public DeltaSpecificationBuilder undeploy(DeployedApplication deployedApplication) {
        this.deployedApplication = deployedApplication;
        this.operation = Operation.DESTROY;
        return this;
    }

    public DeltaSpecificationBuilder initial(DeployedApplication deployedApplication) {
        this.deployedApplication = deployedApplication;
        this.operation = Operation.CREATE;
        return this;
    }

    public DeployedApplication getDeployedApplication() {
        return this.deployedApplication;
    }

    public DeltaSpecification build() {
        return new DefaultDeltaSpecification(this.operation, this.deployedApplication, this.deltas);
    }
}

