package com.xebialabs.deployit.deployment.planner;

import static com.google.common.collect.Lists.newArrayList;
import static com.google.common.collect.Maps.newHashMap;

import java.util.Collection;
import java.util.HashMap;

import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentStep;
import com.xebialabs.deployit.plugin.api.deployment.execution.Plans;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.planning.ReadOnlyRepository;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;

public class DefaultDeploymentPlanningContext implements DeploymentPlanningContext {

    private final Plans.InterleavedPlanBuilder planningResult;
    private final HashMap<String, Object> attributes = newHashMap();
	private DeployedApplication deployedApplication;
	private ReadOnlyRepository readOnlyRepository;

	public DefaultDeploymentPlanningContext(Plans.InterleavedPlanBuilder planningResult, DeployedApplication deployedApplication, ReadOnlyRepository readOnlyRepository) {
        this.planningResult = planningResult;
		this.deployedApplication = deployedApplication;
		this.readOnlyRepository = readOnlyRepository;
	}

    @Override
    public void addStep(DeploymentStep step) {
        planningResult.withStep(step);
    }

    @Override
    public void addSteps(DeploymentStep... steps) {
        planningResult.withSteps(steps);
    }

    @Override
    public void addSteps(Collection<DeploymentStep> steps) {
        planningResult.withSteps(newArrayList(steps));
    }

    @Override
    public Object getAttribute(String param) {
        return attributes.get(param);
    }

    @Override
    public void setAttribute(String param, Object value) {
        attributes.put(param, value);
    }

	@Override
	public DeployedApplication getDeployedApplication() {
		return deployedApplication;
	}

	@Override
	public ReadOnlyRepository getRepository() {
		return readOnlyRepository;
	}
}
