package com.xebialabs.deployit.deployment.planner;

import static com.google.common.collect.Lists.newArrayList;
import static java.util.Collections.unmodifiableList;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.DeltaSpecification;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;

@SuppressWarnings("serial")
public class DefaultDeltaSpecification implements DeltaSpecification, Serializable {

	private Operation operation;
	private DeployedApplication deployedApplication;
	private List<Delta> deltas;

	public DefaultDeltaSpecification(Operation operation, DeployedApplication deployedApplication, List<Delta> deltas) {
		this.operation = operation;
		this.deployedApplication = deployedApplication;
		ArrayList<Delta> deltas1 = newArrayList(deltas);
		Collections.sort(deltas1, new Comparator<Delta>() {
			@SuppressWarnings("rawtypes")
            @Override
			public int compare(Delta delta, Delta delta1) {
				Deployed d1 = delta.getOperation() != Operation.DESTROY ? delta.getDeployed() : delta.getPrevious();
				Deployed d2 = delta1.getOperation() != Operation.DESTROY ? delta1.getDeployed() : delta1.getPrevious();
				return d1.getName().compareTo(d2.getName());
			}
		});
		this.deltas = unmodifiableList(deltas1);
	}

	public Operation getOperation() {
		return operation;
	}

	public DeployedApplication getDeployedApplication() {
		return deployedApplication;
	}

	public List<Delta> getDeltas() {
		return deltas;
	}

}
