package com.xebialabs.deployit.deployment.planner;

import static java.util.Collections.unmodifiableList;

import java.io.Serializable;
import java.util.List;

import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.DeltaSpecification;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;

@SuppressWarnings("serial")
public class DefaultDeltaSpecification implements DeltaSpecification, Serializable {

	private Operation operation;
	private DeployedApplication deployedApplication;
	private List<Delta> deltas;

	public DefaultDeltaSpecification(Operation operation, DeployedApplication deployedApplication, List<Delta> deltas) {
		this.operation = operation;
		this.deployedApplication = deployedApplication;
		this.deltas = unmodifiableList(deltas);
	}

	public Operation getOperation() {
		return operation;
	}

	public DeployedApplication getDeployedApplication() {
		return deployedApplication;
	}

	public List<Delta> getDeltas() {
		return deltas;
	}

}
