/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.user;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.PatternSyntaxException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import org.apache.jackrabbit.commons.iterator.NodeIteratorAdapter;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.PropertyImpl;
import org.apache.jackrabbit.core.security.user.NodeResolver;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TraversingNodeResolver
extends NodeResolver {
    private static final Logger log = LoggerFactory.getLogger(TraversingNodeResolver.class);

    TraversingNodeResolver(Session session, NamePathResolver resolver) {
        super(session, resolver);
    }

    @Override
    public Node findNode(Name nodeName, Name ntName) throws RepositoryException {
        String sr = this.getSearchRoot(ntName);
        if (this.getSession().nodeExists(sr)) {
            try {
                Node root = this.getSession().getNode(sr);
                return this.collectNode(nodeName, ntName, root.getNodes());
            }
            catch (PathNotFoundException e) {
                log.warn("Error while retrieving node " + sr);
            }
        }
        return null;
    }

    @Override
    public Node findNode(Name propertyName, String value, Name ntName) throws RepositoryException {
        String sr = this.getSearchRoot(ntName);
        if (this.getSession().nodeExists(sr)) {
            try {
                Node root = this.getSession().getNode(sr);
                HashSet<Node> matchSet = new HashSet<Node>();
                this.collectNodes(value, Collections.singleton(propertyName), ntName, root.getNodes(), matchSet, true, 1L);
                NodeIteratorAdapter it = new NodeIteratorAdapter(matchSet);
                if (it.hasNext()) {
                    return it.nextNode();
                }
            }
            catch (PathNotFoundException e) {
                log.warn("Error while retrieving node " + sr);
            }
        }
        return null;
    }

    @Override
    public NodeIterator findNodes(Set<Name> propertyNames, String value, Name ntName, boolean exact, long maxSize) throws RepositoryException {
        String sr = this.getSearchRoot(ntName);
        if (this.getSession().nodeExists(sr)) {
            try {
                Node root = this.getSession().getNode(sr);
                HashSet<Node> matchSet = new HashSet<Node>();
                this.collectNodes(value, propertyNames, ntName, root.getNodes(), matchSet, exact, maxSize);
                return new NodeIteratorAdapter(matchSet);
            }
            catch (PathNotFoundException e) {
                log.warn("Error while retrieving node " + sr);
            }
        }
        return NodeIteratorAdapter.EMPTY;
    }

    @Override
    public NodeIterator findNodes(Path relPath, String value, int authorizableType, boolean exact, long maxSize) throws RepositoryException {
        String sr = this.getSearchRoot(authorizableType);
        if (this.getSession().nodeExists(sr)) {
            try {
                String path = this.getNamePathResolver().getJCRPath(relPath);
                NodeResolver.AuthorizableTypePredicate pred = this.getAuthorizableTypePredicate(authorizableType, relPath.getLength() > 1);
                Node root = this.getSession().getNode(sr);
                HashMap<String, Node> matchingNodes = new HashMap<String, Node>();
                this.collectNodes(value, path, pred, root.getNodes(), matchingNodes, exact, maxSize);
                return new NodeIteratorAdapter(matchingNodes.values());
            }
            catch (PathNotFoundException e) {
                log.warn("Error while retrieving node " + sr);
            }
        }
        return NodeIteratorAdapter.EMPTY;
    }

    private Node collectNode(Name nodeName, Name ntName, NodeIterator nodes) {
        NodeImpl match = null;
        while (match == null && nodes.hasNext()) {
            NodeImpl node = (NodeImpl)nodes.nextNode();
            try {
                if (node.isNodeType(ntName) && nodeName.equals(node.getQName())) {
                    match = node;
                    continue;
                }
                if (!node.hasNodes()) continue;
                match = this.collectNode(nodeName, ntName, node.getNodes());
            }
            catch (RepositoryException e) {
                log.warn("Internal error while accessing node", (Throwable)e);
            }
        }
        return match;
    }

    private void collectNodes(String value, Set<Name> propertyNames, Name nodeTypeName, NodeIterator itr, Set<Node> matchSet, boolean exact, long maxSize) {
        while (itr.hasNext()) {
            NodeImpl node = (NodeImpl)itr.nextNode();
            try {
                if (TraversingNodeResolver.matches(node, nodeTypeName, propertyNames, value, exact)) {
                    matchSet.add(node);
                    --maxSize;
                }
                if (!node.hasNodes() || maxSize <= 0L) continue;
                this.collectNodes(value, propertyNames, nodeTypeName, node.getNodes(), matchSet, exact, maxSize);
            }
            catch (RepositoryException e) {
                log.warn("Internal error while accessing node", (Throwable)e);
            }
        }
    }

    private void collectNodes(String value, String relPath, NodeResolver.AuthorizableTypePredicate predicate, NodeIterator itr, Map<String, Node> matchingNodes, boolean exact, long maxSize) {
        while (itr.hasNext()) {
            NodeImpl node = (NodeImpl)itr.nextNode();
            try {
                Node authNode = TraversingNodeResolver.getMatchingNode(node, predicate, relPath, value, exact);
                if (authNode != null) {
                    matchingNodes.put(authNode.getIdentifier(), authNode);
                    --maxSize;
                    continue;
                }
                if (!node.hasNodes() || maxSize <= 0L) continue;
                this.collectNodes(value, relPath, predicate, node.getNodes(), matchingNodes, exact, maxSize);
            }
            catch (RepositoryException e) {
                log.warn("Internal error while accessing node", (Throwable)e);
            }
        }
    }

    private static boolean matches(NodeImpl node, Name nodeTypeName, Collection<Name> propertyNames, String value, boolean exact) throws RepositoryException {
        boolean match;
        block9: {
            match = false;
            if (node.isNodeType(nodeTypeName)) {
                if (value == null) {
                    match = true;
                } else {
                    try {
                        if (propertyNames.isEmpty()) {
                            match = exact ? node.getName().equals(value) : node.getName().matches(".*" + value + ".*");
                            break block9;
                        }
                        Iterator<Name> pItr = propertyNames.iterator();
                        while (!match && pItr.hasNext()) {
                            Name propertyName = pItr.next();
                            if (!node.hasProperty(propertyName)) continue;
                            PropertyImpl prop = node.getProperty(propertyName);
                            if (prop.isMultiple()) {
                                Value[] values = prop.getValues();
                                for (int i = 0; i < values.length && !match; ++i) {
                                    match = TraversingNodeResolver.matches(value, values[i].getString(), exact);
                                }
                                continue;
                            }
                            match = TraversingNodeResolver.matches(value, prop.getString(), exact);
                        }
                    }
                    catch (PatternSyntaxException pe) {
                        log.debug("couldn't search for {}, pattern invalid: {}", (Object)value, (Object)pe.getMessage());
                    }
                }
            }
        }
        return match;
    }

    private static Node getMatchingNode(NodeImpl node, NodeResolver.AuthorizableTypePredicate predicate, String relPath, String value, boolean exact) throws RepositoryException {
        boolean match = false;
        Node authNode = predicate.getAuthorizableNode(node);
        if (authNode != null && node.hasProperty(relPath)) {
            try {
                Property prop = node.getProperty(relPath);
                if (prop.isMultiple()) {
                    Value[] values = prop.getValues();
                    for (int i = 0; i < values.length && !match; ++i) {
                        match = TraversingNodeResolver.matches(value, values[i].getString(), exact);
                    }
                } else {
                    match = TraversingNodeResolver.matches(value, prop.getString(), exact);
                }
            }
            catch (PatternSyntaxException pe) {
                log.debug("couldn't search for {}, pattern invalid: {}", (Object)value, (Object)pe.getMessage());
            }
        }
        return match ? authNode : null;
    }

    private static boolean matches(String value, String toMatch, boolean exact) {
        return exact ? toMatch.equals(value) : toMatch.matches(".*" + value + ".*");
    }
}

