/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.IOException;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.jackrabbit.core.query.lucene.HierarchyResolver;
import org.apache.jackrabbit.core.query.lucene.IndexFormatVersion;
import org.apache.jackrabbit.core.query.lucene.NameQuery;
import org.apache.jackrabbit.core.query.lucene.NamespaceMappings;
import org.apache.jackrabbit.core.query.lucene.hits.AbstractHitCollector;
import org.apache.jackrabbit.core.query.lucene.hits.ScorerHits;
import org.apache.jackrabbit.spi.Name;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Weight;

class ParentAxisQuery
extends Query {
    private final Query contextQuery;
    private final Name nameTest;
    private final IndexFormatVersion version;
    private final NamespaceMappings nsMappings;
    private Scorer contextScorer;

    ParentAxisQuery(Query context, Name nameTest, IndexFormatVersion version, NamespaceMappings nsMappings) {
        this.contextQuery = context;
        this.nameTest = nameTest;
        this.version = version;
        this.nsMappings = nsMappings;
    }

    public Weight createWeight(Searcher searcher) {
        return new ParentAxisWeight(searcher);
    }

    public void extractTerms(Set<Term> terms) {
        this.contextQuery.extractTerms(terms);
    }

    public Query rewrite(IndexReader reader) throws IOException {
        Query cQuery = this.contextQuery.rewrite(reader);
        if (cQuery == this.contextQuery) {
            return this;
        }
        return new ParentAxisQuery(cQuery, this.nameTest, this.version, this.nsMappings);
    }

    public String toString(String field) {
        StringBuffer sb = new StringBuffer();
        sb.append("ParentAxisQuery(");
        sb.append(this.contextQuery);
        sb.append(", ");
        sb.append(this.nameTest);
        sb.append(")");
        return sb.toString();
    }

    private class ParentAxisScorer
    extends Scorer {
        private final IndexReader reader;
        private final HierarchyResolver hResolver;
        private final Searcher searcher;
        private BitSet hits;
        private final Map<Integer, Float> scores;
        private int nextDoc;
        private Float firstScore;

        protected ParentAxisScorer(Similarity similarity, IndexReader reader, Searcher searcher, HierarchyResolver resolver) {
            super(similarity);
            this.scores = new HashMap<Integer, Float>();
            this.nextDoc = -1;
            this.reader = reader;
            this.searcher = searcher;
            this.hResolver = resolver;
        }

        public int nextDoc() throws IOException {
            if (this.nextDoc == Integer.MAX_VALUE) {
                return this.nextDoc;
            }
            this.calculateParent();
            this.nextDoc = this.hits.nextSetBit(this.nextDoc + 1);
            if (this.nextDoc < 0) {
                this.nextDoc = Integer.MAX_VALUE;
            }
            return this.nextDoc;
        }

        public int docID() {
            return this.nextDoc;
        }

        public float score() throws IOException {
            Float score = this.scores.get(this.nextDoc);
            if (score == null) {
                score = this.firstScore;
            }
            return score.floatValue();
        }

        public int advance(int target) throws IOException {
            if (this.nextDoc == Integer.MAX_VALUE) {
                return this.nextDoc;
            }
            if (target == Integer.MAX_VALUE) {
                this.nextDoc = Integer.MAX_VALUE;
                return this.nextDoc;
            }
            this.calculateParent();
            this.nextDoc = this.hits.nextSetBit(target);
            if (this.nextDoc < 0) {
                this.nextDoc = Integer.MAX_VALUE;
            }
            return this.nextDoc;
        }

        private void calculateParent() throws IOException {
            if (this.hits == null) {
                this.hits = new BitSet(this.reader.maxDoc());
                final IOException[] ex = new IOException[1];
                if (ParentAxisQuery.this.contextScorer != null) {
                    ParentAxisQuery.this.contextScorer.score((Collector)new AbstractHitCollector(){
                        private int[] docs = new int[1];

                        @Override
                        protected void collect(int doc, float score) {
                            try {
                                this.docs = ParentAxisScorer.this.hResolver.getParents(doc, this.docs);
                                if (this.docs.length == 1) {
                                    ParentAxisScorer.this.hits.set(this.docs[0]);
                                    if (ParentAxisScorer.this.firstScore == null) {
                                        ParentAxisScorer.this.firstScore = Float.valueOf(score);
                                    } else if (ParentAxisScorer.this.firstScore.floatValue() != score) {
                                        ParentAxisScorer.this.scores.put(doc, Float.valueOf(score));
                                    }
                                } else {
                                    for (int docNum : this.docs) {
                                        ParentAxisScorer.this.hits.set(docNum);
                                        if (ParentAxisScorer.this.firstScore == null) {
                                            ParentAxisScorer.this.firstScore = Float.valueOf(score);
                                            continue;
                                        }
                                        if (ParentAxisScorer.this.firstScore.floatValue() == score) continue;
                                        ParentAxisScorer.this.scores.put(doc, Float.valueOf(score));
                                    }
                                }
                            }
                            catch (IOException e) {
                                ex[0] = e;
                            }
                        }
                    });
                }
                if (ex[0] != null) {
                    throw ex[0];
                }
                if (ParentAxisQuery.this.nameTest != null) {
                    NameQuery nameQuery = new NameQuery(ParentAxisQuery.this.nameTest, ParentAxisQuery.this.version, ParentAxisQuery.this.nsMappings);
                    ScorerHits nameHits = new ScorerHits(nameQuery.weight(this.searcher).scorer(this.reader, true, false));
                    int i = this.hits.nextSetBit(0);
                    while (i >= 0) {
                        int doc = nameHits.skipTo(i);
                        if (doc == -1) {
                            this.hits.clear(i, this.hits.length());
                        } else if (doc > i) {
                            this.hits.clear(i, doc);
                            i = doc;
                        }
                        i = this.hits.nextSetBit(i + 1);
                    }
                }
            }
        }
    }

    private class ParentAxisWeight
    extends Weight {
        private final Searcher searcher;

        private ParentAxisWeight(Searcher searcher) {
            this.searcher = searcher;
        }

        public Query getQuery() {
            return ParentAxisQuery.this;
        }

        public float getValue() {
            return 1.0f;
        }

        public float sumOfSquaredWeights() throws IOException {
            return 1.0f;
        }

        public void normalize(float norm) {
        }

        public Scorer scorer(IndexReader reader, boolean scoreDocsInOrder, boolean topScorer) throws IOException {
            ParentAxisQuery.this.contextScorer = ParentAxisQuery.this.contextQuery.weight(this.searcher).scorer(reader, scoreDocsInOrder, false);
            HierarchyResolver resolver = (HierarchyResolver)reader;
            return new ParentAxisScorer(this.searcher.getSimilarity(), reader, this.searcher, resolver);
        }

        public Explanation explain(IndexReader reader, int doc) throws IOException {
            return new Explanation();
        }
    }
}

