/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ldap.core.support;

import com.sun.jndi.ldap.LdapCtxFactory;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.JdkVersion;
import org.springframework.ldap.core.AuthenticationSource;
import org.springframework.ldap.core.DistinguishedName;
import org.springframework.ldap.core.support.BaseLdapPathContextSource;
import org.springframework.ldap.core.support.DefaultDirObjectFactory;
import org.springframework.ldap.core.support.DirContextAuthenticationStrategy;
import org.springframework.ldap.core.support.SimpleDirContextAuthenticationStrategy;
import org.springframework.ldap.support.LdapUtils;

public abstract class AbstractContextSource
implements BaseLdapPathContextSource,
InitializingBean {
    private static final Class DEFAULT_CONTEXT_FACTORY = LdapCtxFactory.class;
    private static final Class DEFAULT_DIR_OBJECT_FACTORY = DefaultDirObjectFactory.class;
    private Class dirObjectFactory = DEFAULT_DIR_OBJECT_FACTORY;
    private Class contextFactory = DEFAULT_CONTEXT_FACTORY;
    private DistinguishedName base = DistinguishedName.EMPTY_PATH;
    protected String userDn = "";
    protected String password = "";
    private String[] urls;
    private boolean pooled = false;
    private Hashtable baseEnv = new Hashtable();
    private Hashtable anonymousEnv;
    private AuthenticationSource authenticationSource;
    private boolean cacheEnvironmentProperties = true;
    private boolean anonymousReadOnly = false;
    private String referral = null;
    private static final Log log = LogFactory.getLog((Class)AbstractContextSource.class);
    public static final String SUN_LDAP_POOLING_FLAG = "com.sun.jndi.ldap.connect.pool";
    private static final String JDK_142 = "1.4.2";
    private DirContextAuthenticationStrategy authenticationStrategy = new SimpleDirContextAuthenticationStrategy();

    public DirContext getContext(String principal, String credentials) {
        DirContext ctx = this.createContext(this.getAuthenticatedEnv(principal, credentials));
        try {
            this.authenticationStrategy.processContextAfterCreation(ctx, principal, credentials);
            return ctx;
        }
        catch (NamingException e) {
            this.closeContext(ctx);
            throw LdapUtils.convertLdapException(e);
        }
    }

    public DirContext getReadOnlyContext() {
        if (!this.anonymousReadOnly) {
            return this.getContext(this.authenticationSource.getPrincipal(), this.authenticationSource.getCredentials());
        }
        return this.createContext(this.getAnonymousEnv());
    }

    public DirContext getReadWriteContext() {
        return this.getContext(this.authenticationSource.getPrincipal(), this.authenticationSource.getCredentials());
    }

    protected void setupAuthenticatedEnvironment(Hashtable env, String principal, String credentials) {
        try {
            this.authenticationStrategy.setupEnvironment(env, principal, credentials);
        }
        catch (NamingException e) {
            throw LdapUtils.convertLdapException(e);
        }
    }

    private void closeContext(DirContext ctx) {
        if (ctx != null) {
            try {
                ctx.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected String assembleProviderUrlString(String[] ldapUrls) {
        StringBuffer providerUrlBuffer = new StringBuffer(1024);
        for (int i = 0; i < ldapUrls.length; ++i) {
            providerUrlBuffer.append(ldapUrls[i]);
            if (!DistinguishedName.EMPTY_PATH.equals(this.base) && !ldapUrls[i].endsWith("/")) {
                providerUrlBuffer.append("/");
            }
            providerUrlBuffer.append(this.base.toUrl());
            providerUrlBuffer.append(' ');
        }
        return providerUrlBuffer.toString().trim();
    }

    public void setBase(String base) {
        this.base = new DistinguishedName(base);
    }

    protected DistinguishedName getBase() {
        return new DistinguishedName(this.base);
    }

    public DistinguishedName getBaseLdapPath() {
        return this.getBase().immutableDistinguishedName();
    }

    public String getBaseLdapPathAsString() {
        return this.getBaseLdapPath().toString();
    }

    protected DirContext createContext(Hashtable environment) {
        DirContext ctx = null;
        try {
            ctx = this.getDirContextInstance(environment);
            if (log.isInfoEnabled()) {
                Hashtable<?, ?> ctxEnv = ctx.getEnvironment();
                String ldapUrl = (String)ctxEnv.get("java.naming.provider.url");
                log.debug((Object)("Got Ldap context on server '" + ldapUrl + "'"));
            }
            return ctx;
        }
        catch (NamingException e) {
            this.closeContext(ctx);
            throw LdapUtils.convertLdapException(e);
        }
    }

    public void setContextFactory(Class contextFactory) {
        this.contextFactory = contextFactory;
    }

    public Class getContextFactory() {
        return this.contextFactory;
    }

    public void setDirObjectFactory(Class dirObjectFactory) {
        this.dirObjectFactory = dirObjectFactory;
    }

    public Class getDirObjectFactory() {
        return this.dirObjectFactory;
    }

    public void afterPropertiesSet() throws Exception {
        if (ArrayUtils.isEmpty((Object[])this.urls)) {
            throw new IllegalArgumentException("At least one server url must be set");
        }
        if (!DistinguishedName.EMPTY_PATH.equals(this.base) && this.getJdkVersion().compareTo(JDK_142) < 0) {
            throw new IllegalArgumentException("Base path is not supported for JDK versions < 1.4.2");
        }
        if (this.authenticationSource == null) {
            log.debug((Object)"AuthenticationSource not set - using default implementation");
            if (StringUtils.isBlank((String)this.userDn)) {
                log.info((Object)"Property 'userDn' not set - anonymous context will be used for read-write operations");
            } else if (StringUtils.isBlank((String)this.password)) {
                log.info((Object)"Property 'password' not set - blank password will be used");
            }
            this.authenticationSource = new SimpleAuthenticationSource();
        }
        if (this.cacheEnvironmentProperties) {
            this.anonymousEnv = this.setupAnonymousEnv();
        }
    }

    private Hashtable setupAnonymousEnv() {
        if (this.pooled) {
            this.baseEnv.put(SUN_LDAP_POOLING_FLAG, "true");
            log.debug((Object)"Using LDAP pooling.");
        } else {
            this.baseEnv.remove(SUN_LDAP_POOLING_FLAG);
            log.debug((Object)"Not using LDAP pooling");
        }
        Hashtable<String, Object> env = new Hashtable<String, Object>(this.baseEnv);
        env.put("java.naming.factory.initial", this.contextFactory.getName());
        env.put("java.naming.provider.url", this.assembleProviderUrlString(this.urls));
        if (this.dirObjectFactory != null) {
            env.put("java.naming.factory.object", this.dirObjectFactory.getName());
        }
        if (!StringUtils.isBlank((String)this.referral)) {
            env.put("java.naming.referral", this.referral);
        }
        if (!DistinguishedName.EMPTY_PATH.equals(this.base)) {
            env.put("org.springframework.ldap.base.path", this.base);
        }
        log.debug((Object)("Trying provider Urls: " + this.assembleProviderUrlString(this.urls)));
        return env;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setUserDn(String userDn) {
        this.userDn = userDn;
    }

    public void setUrls(String[] urls) {
        this.urls = (String[])urls.clone();
    }

    public String[] getUrls() {
        return (String[])this.urls.clone();
    }

    public void setUrl(String url) {
        this.urls = new String[]{url};
    }

    public void setPooled(boolean pooled) {
        this.pooled = pooled;
    }

    public boolean isPooled() {
        return this.pooled;
    }

    public void setBaseEnvironmentProperties(Map baseEnvironmentProperties) {
        this.baseEnv = new Hashtable(baseEnvironmentProperties);
    }

    String getJdkVersion() {
        return JdkVersion.getJavaVersion();
    }

    protected Hashtable getAnonymousEnv() {
        if (this.cacheEnvironmentProperties) {
            return this.anonymousEnv;
        }
        return this.setupAnonymousEnv();
    }

    protected Hashtable getAuthenticatedEnv(String principal, String credentials) {
        Hashtable env = new Hashtable(this.getAnonymousEnv());
        this.setupAuthenticatedEnvironment(env, principal, credentials);
        return env;
    }

    public void setAuthenticationSource(AuthenticationSource authenticationSource) {
        this.authenticationSource = authenticationSource;
    }

    public AuthenticationSource getAuthenticationSource() {
        return this.authenticationSource;
    }

    public void setCacheEnvironmentProperties(boolean cacheEnvironmentProperties) {
        this.cacheEnvironmentProperties = cacheEnvironmentProperties;
    }

    public void setAnonymousReadOnly(boolean anonymousReadOnly) {
        this.anonymousReadOnly = anonymousReadOnly;
    }

    public boolean isAnonymousReadOnly() {
        return this.anonymousReadOnly;
    }

    public void setAuthenticationStrategy(DirContextAuthenticationStrategy authenticationStrategy) {
        this.authenticationStrategy = authenticationStrategy;
    }

    public void setReferral(String referral) {
        this.referral = referral;
    }

    protected abstract DirContext getDirContextInstance(Hashtable var1) throws NamingException;

    class SimpleAuthenticationSource
    implements AuthenticationSource {
        SimpleAuthenticationSource() {
        }

        public String getPrincipal() {
            return AbstractContextSource.this.userDn;
        }

        public String getCredentials() {
            return AbstractContextSource.this.password;
        }
    }
}

