/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.booter.local.PluginVersions;
import com.xebialabs.deployit.core.rest.secured.AbstractSecuredResource;
import com.xebialabs.deployit.engine.api.ServerService;
import com.xebialabs.deployit.engine.api.dto.ServerInfo;
import com.xebialabs.deployit.engine.api.dto.ServerPluginInfo;
import com.xebialabs.deployit.engine.spi.event.RepositoryGarbageCollectedEvent;
import com.xebialabs.deployit.engine.spi.event.SystemStoppedEvent;
import com.xebialabs.deployit.engine.spi.exception.DeployitException;
import com.xebialabs.deployit.event.EventBusHolder;
import com.xebialabs.deployit.event.ShutdownEvent;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.deployit.service.gc.GarbageCollectionService;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Controller;

@Controller
public class ServerResource
extends AbstractSecuredResource
implements ServerService {
    @Autowired
    private GarbageCollectionService garbageCollectionService;

    public void shutdown() {
        this.checkPermission(PlatformPermissions.ADMIN);
        EventBusHolder.publish((Object)new SystemStoppedEvent());
        EventBusHolder.publish((Object)new ShutdownEvent());
    }

    public ServerInfo getInfo() {
        ClassPathResource resource = new ClassPathResource("com/xebialabs/deployit/release.properties");
        Properties release = new Properties();
        try {
            release.load(resource.getInputStream());
            ServerInfo si = new ServerInfo();
            si.setVersion(release.getProperty("version"));
            for (String plugin : PluginVersions.getRegisteredPlugins()) {
                si.getPluginsInfo().add(new ServerPluginInfo(plugin, PluginVersions.getVersionFor((String)plugin)));
            }
            si.setClasspathEntries(ServerResource.getServerClassPath());
            return si;
        }
        catch (IOException e) {
            throw new DeployitException((Throwable)e);
        }
    }

    public void logout() {
    }

    private static List<String> getServerClassPath() {
        String classpath = System.getProperty("java.class.path");
        return Lists.newArrayList((Object[])classpath.split(System.getProperty("path.separator")));
    }

    public void gc() {
        this.checkPermission(PlatformPermissions.ADMIN);
        this.garbageCollectionService.runGarbageCollector();
        EventBusHolder.publish((Object)new RepositoryGarbageCollectedEvent());
    }
}

