/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.importer.reader;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.exception.RuntimeIOException;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Application;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.Version;
import com.xebialabs.deployit.plugin.api.udm.artifact.Artifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.SourceArtifact;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.server.api.importer.ImportSource;
import com.xebialabs.deployit.server.api.importer.ImportedPackage;
import com.xebialabs.deployit.server.api.importer.ImportingContext;
import com.xebialabs.deployit.server.api.importer.PackageInfo;
import com.xebialabs.deployit.server.api.util.IdGenerator;
import com.xebialabs.deployit.service.importer.ImporterException;
import com.xebialabs.deployit.service.importer.reader.ManifestReader;
import com.xebialabs.deployit.util.GuavaFiles;
import com.xebialabs.deployit.util.TFiles;
import com.xebialabs.overthere.local.LocalFile;
import com.xebialabs.xltype.serialization.CiReference;
import de.schlichtherle.truezip.file.TArchiveDetector;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.fs.FsSyncException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManifestReaderDriver {
    static final String REFERENCES = "references";
    static final String READ_CIS = "readCis";
    static final String TEMPORARY_FILES = "temporaryFiles";
    private ManifestReader reader;
    private ImportSource source;
    private static final Logger logger = LoggerFactory.getLogger(ManifestReaderDriver.class);

    public ManifestReaderDriver(ImportSource source, ManifestReader reader) {
        this.source = source;
        this.reader = reader;
    }

    public PackageInfo readPackageInfo(ImportingContext context) {
        PackageInfo packageInfo = new PackageInfo(this.source);
        this.reader.readPackageData(packageInfo, context);
        context.setAttribute(TEMPORARY_FILES, (Object)Lists.newArrayList());
        return packageInfo;
    }

    public ImportedPackage readDeploymentPackage(PackageInfo packageInfo, ImportingContext context) {
        Application app = this.getApplication(packageInfo, context);
        Version version = this.readVersion(packageInfo, app, context);
        ImportedPackage importedPackage = new ImportedPackage(packageInfo, app, version);
        this.readDeployables(importedPackage, context);
        return importedPackage;
    }

    private void readDeployables(ImportedPackage importedPackage, ImportingContext context) {
        ManifestReader.ManifestCiReader versionReader = this.reader.versionReader();
        if (!versionReader.hasProperty("deployables")) {
            throw new ImporterException("Manifest missing required 'deployables' for [%s]", importedPackage.getPackageInfo().getSource().getFile().getName());
        }
        List<ManifestReader.ManifestCiReader> deployableReaders = versionReader.propertyAsNestedCis("deployables");
        for (ManifestReader.ManifestCiReader deployableReader : deployableReaders) {
            ConfigurationItem configurationItem = this.readCi(deployableReader, importedPackage.getVersion().getId(), context);
            if (!(configurationItem instanceof Deployable)) {
                throw new ImporterException("ConfigurationItem [%s] read from package [%s] is not a Deployable.", configurationItem.getId(), importedPackage.getVersion().getId());
            }
            importedPackage.addDeployable((Deployable)configurationItem);
        }
    }

    private Version readVersion(PackageInfo packageInfo, Application app, ImportingContext context) {
        ManifestReader.ManifestCiReader ciReader = this.reader.versionReader();
        Descriptor versionDescriptor = ciReader.type().getDescriptor();
        Version v = (Version)versionDescriptor.newInstance(IdGenerator.generateId((String)app.getId(), (String)packageInfo.getApplicationVersion()));
        for (PropertyDescriptor propertyDescriptor : versionDescriptor.getPropertyDescriptors()) {
            if (propertyDescriptor.getName().equals("deployables")) continue;
            this.readProperty(ciReader, propertyDescriptor, (ConfigurationItem)v, context);
        }
        ManifestReaderDriver.getReadCis(context).put(packageInfo.getApplicationVersion(), (ConfigurationItem)v);
        return v;
    }

    private void readProperty(ManifestReader.ManifestCiReader ciReader, PropertyDescriptor pd, ConfigurationItem ci, ImportingContext context) {
        if (!ciReader.hasProperty(pd.getName())) {
            return;
        }
        switch (pd.getKind()) {
            case BOOLEAN: 
            case INTEGER: 
            case STRING: 
            case ENUM: 
            case DATE: {
                String val = ciReader.propertyAsString(pd.getName());
                if (Strings.isBlank((String)val)) break;
                pd.set(ci, (Object)val);
                break;
            }
            case CI: {
                String ref = ciReader.propertyAsCiRef(pd.getName());
                if (Strings.isBlank((String)ref)) break;
                ManifestReaderDriver.getReferences(context).add(new CiReference(ci, pd, ref));
                break;
            }
            case SET_OF_STRING: 
            case LIST_OF_STRING: {
                List<String> strings = ciReader.propertyAsStringCollection(pd.getName());
                if (strings.isEmpty()) break;
                pd.set(ci, pd.getKind() == PropertyKind.SET_OF_STRING ? Sets.newHashSet(strings) : strings);
                break;
            }
            case SET_OF_CI: 
            case LIST_OF_CI: {
                if (pd.isAsContainment()) {
                    List<ConfigurationItem> items = this.readNestedCis(ciReader, pd.getName(), ci.getId(), context);
                    pd.set(ci, pd.getKind() == PropertyKind.SET_OF_CI ? Sets.newHashSet(items) : items);
                    break;
                }
                List<String> refs = ciReader.propertyAsCiRefCollection(pd.getName());
                if (refs.isEmpty()) break;
                ManifestReaderDriver.getReferences(context).add(new CiReference(ci, pd, refs));
                break;
            }
            case MAP_STRING_STRING: {
                Map<String, String> map = ciReader.propertyAsMapStringString(pd.getName());
                pd.set(ci, map);
            }
        }
    }

    private List<ConfigurationItem> readNestedCis(ManifestReader.ManifestCiReader ciReader, String name, String parentId, ImportingContext context) {
        List<ManifestReader.ManifestCiReader> readers = ciReader.propertyAsNestedCis(name);
        ArrayList configurationItems = Lists.newArrayList();
        for (ManifestReader.ManifestCiReader manifestCiReader : readers) {
            ConfigurationItem ci = this.readCi(manifestCiReader, parentId, context);
            configurationItems.add(ci);
        }
        return configurationItems;
    }

    private ConfigurationItem readCi(ManifestReader.ManifestCiReader ciReader, String parentId, ImportingContext context) {
        Type type = ciReader.type();
        ConfigurationItem configurationItem = type.getDescriptor().newInstance(IdGenerator.generateId((String)parentId, (String)ciReader.name()));
        for (PropertyDescriptor propertyDescriptor : type.getDescriptor().getPropertyDescriptors()) {
            this.readProperty(ciReader, propertyDescriptor, configurationItem, context);
        }
        if (configurationItem instanceof SourceArtifact) {
            this.readArtifactData((Artifact)configurationItem, ciReader.file(), context);
        }
        ManifestReaderDriver.getReadCis(context).put(ciReader.name(), configurationItem);
        return configurationItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readArtifactData(Artifact artifact, String fileName, ImportingContext ctx) {
        TFile sourceArchive = new TFile(this.source.getFile());
        try {
            TFile tempFolder = ManifestReaderDriver.createTempFolderForImport(ctx, artifact);
            ((List)ctx.getAttribute(TEMPORARY_FILES)).add(tempFolder);
            TFile dest = ManifestReaderDriver.copyArtifactData(sourceArchive, fileName, tempFolder, artifact);
            artifact.setFile(LocalFile.valueOf((File)dest.getFile()));
        }
        finally {
            if (sourceArchive.isArchive()) {
                try {
                    TFile.umount((TFile)sourceArchive);
                }
                catch (FsSyncException e) {
                    logger.error("Unable to release resources for archive {}", (Object)sourceArchive.getName());
                    logger.error("Following exception occurred while trying to release resources: {}", (Object)e.getMessage());
                }
            }
        }
    }

    private static TFile copyArtifactData(TFile sourceArchive, String fileName, TFile tempFolder, Artifact artifact) {
        TFile artifactFile = new TFile((File)sourceArchive, fileName, TArchiveDetector.NULL);
        if (!artifactFile.exists()) {
            throw new RuntimeIOException(String.format("The file %s could not be found in the package.", fileName));
        }
        TFile dest = new TFile((File)tempFolder, artifactFile.getName());
        try {
            artifactFile.cp_r((File)dest);
        }
        catch (IOException e) {
            throw new RuntimeIOException(String.format("Could not copy %s to %s while importing %s", artifactFile, dest, artifact.getId()), (Throwable)e);
        }
        return dest;
    }

    private static TFile createTempFolderForImport(ImportingContext ctx, Artifact artifact) {
        try {
            String name = "temp-" + artifact.getName();
            TFile tempFolder = new TFile(File.createTempFile(name, "")).rm().mkdir(false);
            ((List)ctx.getAttribute(TEMPORARY_FILES)).add(tempFolder);
            logger.debug("Created Temporary folder {}", (Object)tempFolder);
            return tempFolder;
        }
        catch (IOException e) {
            throw new RuntimeIOException((Throwable)e);
        }
    }

    private Application getApplication(PackageInfo packageInfo, ImportingContext context) {
        Application app = (Application)Type.valueOf(Application.class).getDescriptor().newInstance(packageInfo.getApplicationId());
        ManifestReaderDriver.getReadCis(context).put(packageInfo.getApplicationName(), (ConfigurationItem)app);
        return app;
    }

    static List<CiReference> getReferences(ImportingContext context) {
        List l = (List)context.getAttribute(REFERENCES);
        if (l == null) {
            l = Lists.newArrayList();
            context.setAttribute(REFERENCES, (Object)l);
        }
        return l;
    }

    static Map<String, ConfigurationItem> getReadCis(ImportingContext context) {
        Map m = (Map)context.getAttribute(READ_CIS);
        if (m == null) {
            m = Maps.newHashMap();
            context.setAttribute(READ_CIS, (Object)m);
        }
        return m;
    }

    public void cleanUp(PackageInfo packageInfo, ImportingContext context) {
        List files = (List)context.getAttribute(TEMPORARY_FILES);
        for (TFile file : files) {
            logger.debug("Cleaning up temporary file {}", (Object)file);
            try {
                File javaFile = file.getFile();
                if (javaFile.isDirectory()) {
                    GuavaFiles.deleteRecursively((File)javaFile);
                    continue;
                }
                if (javaFile.delete()) continue;
                logger.info("Couldn't delete file: {}", (Object)javaFile);
            }
            catch (IOException e) {
                logger.error("Couldn't clean up file {}", (Object)file, (Object)e);
            }
        }
        TFiles.umountQuietly((TFile)new TFile(packageInfo.getSource().getFile()));
    }

    public void resolveReferences(RepositoryService repositoryService, ImportingContext ctx) {
        List<CiReference> references = ManifestReaderDriver.getReferences(ctx);
        for (CiReference reference : references) {
            ArrayList resolvedCIs = Lists.newArrayList();
            for (String id : reference.getIds()) {
                ConfigurationItem alsoRead = ManifestReaderDriver.getReadCis(ctx).get(id);
                if (alsoRead != null) {
                    resolvedCIs.add(alsoRead);
                    continue;
                }
                resolvedCIs.add(repositoryService.read(id));
            }
            reference.set((List)resolvedCIs);
        }
    }
}

