/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.importer.reader;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.service.importer.ImporterException;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;

public class ManifestEntry {
    static final String CI = "CI-";
    static final String TYPE_ATTRIBUTE_NAME = "CI-Type";
    static final String NAME_ATTRIBUTE_NAME = "CI-Name";
    private final String name;
    private final Attributes attributes;

    public ManifestEntry(String name, Attributes attributes) {
        this.name = name.trim();
        this.attributes = attributes;
    }

    public String getName() {
        return this.name;
    }

    public String getValue(PropertyDescriptor pd) {
        for (String s : ManifestEntry.getPossibleNames(pd)) {
            if (!this.attributes.containsKey(new Attributes.Name(CI + s))) continue;
            return this.attributes.getValue(CI + s);
        }
        return null;
    }

    private static Set<String> getPossibleNames(PropertyDescriptor pd) {
        return Sets.union((Set)Sets.newHashSet((Object[])new String[]{pd.getName()}), (Set)pd.getAliases()).immutableCopy();
    }

    public String getValue(String name) {
        return this.attributes.getValue(name);
    }

    public Type getType() {
        String type = this.attributes.getValue(TYPE_ATTRIBUTE_NAME);
        if (type != null) {
            return Type.valueOf((String)type);
        }
        throw new ImporterException("Could not import Name: %s because of missing %s entry in MANIFEST.MF", this.name, TYPE_ATTRIBUTE_NAME);
    }

    public String getCiName() {
        return this.attributes.getValue(NAME_ATTRIBUTE_NAME);
    }

    public Map<String, String> getMap(PropertyDescriptor pd) {
        Iterable keyStart = Iterables.transform(ManifestEntry.getPossibleNames(pd), (Function)new Function<String, String>(){

            public String apply(String input) {
                return (ManifestEntry.CI + input + "-").toLowerCase();
            }
        });
        HashMap map = Maps.newHashMap();
        for (Map.Entry<Object, Object> entry : this.attributes.entrySet()) {
            final String s = entry.getKey().toString();
            Optional option = Iterables.tryFind((Iterable)keyStart, (Predicate)new Predicate<String>(){

                public boolean apply(String input) {
                    return s.toLowerCase().startsWith(input);
                }
            });
            if (!option.isPresent()) continue;
            String mapKey = s.substring(((String)option.get()).length());
            String mapValue = (String)entry.getValue();
            map.put(mapKey, mapValue);
        }
        return map;
    }

    public Collection<String> getStrings(PropertyDescriptor pd) {
        final HashSet startsWithPossibilities = Sets.newHashSet();
        startsWithPossibilities.addAll(Collections2.transform(ManifestEntry.getPossibleNames(pd), (Function)new Function<String, String>(){

            public String apply(String input) {
                return (ManifestEntry.CI + input + "-EntryValue").toLowerCase();
            }
        }));
        final HashSet equalPossibilities = Sets.newHashSet();
        equalPossibilities.addAll(Collections2.transform(ManifestEntry.getPossibleNames(pd), (Function)new Function<String, String>(){

            public String apply(String input) {
                return (ManifestEntry.CI + input).toLowerCase();
            }
        }));
        Predicate<Object> is_collection_entry = new Predicate<Object>(){

            public boolean apply(Object key) {
                String entryKey = key.toString().toLowerCase().trim();
                boolean foundStartsWith = false;
                for (String startsWithPossibility : startsWithPossibilities) {
                    foundStartsWith = foundStartsWith || entryKey.startsWith(startsWithPossibility);
                }
                return foundStartsWith || Iterables.any((Iterable)equalPossibilities, (Predicate)Predicates.equalTo((Object)entryKey));
            }
        };
        Map filteredMap = Maps.filterKeys((Map)this.attributes, (Predicate)is_collection_entry);
        if (filteredMap.isEmpty()) {
            return Collections.emptyList();
        }
        List sortedKeys = Ordering.from((Comparator)new Comparator<Object>(){

            @Override
            public int compare(Object o, Object o2) {
                return o.toString().compareTo(o2.toString());
            }
        }).sortedCopy(filteredMap.keySet());
        return Lists.transform((List)sortedKeys, (Function)new Function<Object, String>(){

            public String apply(Object input) {
                return ManifestEntry.this.attributes.get(input).toString();
            }
        });
    }
}

