/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.fs.FsConcurrentModel;
import de.schlichtherle.truezip.fs.FsController;
import de.schlichtherle.truezip.fs.FsDecoratingConcurrentModelController;
import de.schlichtherle.truezip.fs.FsEntry;
import de.schlichtherle.truezip.fs.FsEntryName;
import de.schlichtherle.truezip.fs.FsInputOption;
import de.schlichtherle.truezip.fs.FsNotWriteLockedException;
import de.schlichtherle.truezip.fs.FsOutputOption;
import de.schlichtherle.truezip.fs.FsSyncException;
import de.schlichtherle.truezip.fs.FsSyncOption;
import de.schlichtherle.truezip.io.DecoratingInputStream;
import de.schlichtherle.truezip.io.DecoratingOutputStream;
import de.schlichtherle.truezip.io.DecoratingSeekableByteChannel;
import de.schlichtherle.truezip.rof.DecoratingReadOnlyFile;
import de.schlichtherle.truezip.rof.ReadOnlyFile;
import de.schlichtherle.truezip.socket.DecoratingInputSocket;
import de.schlichtherle.truezip.socket.DecoratingOutputSocket;
import de.schlichtherle.truezip.socket.InputSocket;
import de.schlichtherle.truezip.socket.OutputSocket;
import de.schlichtherle.truezip.util.BitField;
import de.schlichtherle.truezip.util.ExceptionHandler;
import de.schlichtherle.truezip.util.JSE7;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.SeekableByteChannel;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.swing.Icon;
import net.jcip.annotations.Immutable;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
@DefaultAnnotation(value={NonNull.class})
public final class FsConcurrentController
extends FsDecoratingConcurrentModelController<FsController<? extends FsConcurrentModel>> {
    private static final ConcurrentSocketFactory CONCURRENT_SOCKET_FACTORY = JSE7.AVAILABLE ? ConcurrentSocketFactory.NIO2 : ConcurrentSocketFactory.OIO;
    @CheckForNull
    private volatile ReentrantReadWriteLock.ReadLock readLock;
    @CheckForNull
    private volatile ReentrantReadWriteLock.WriteLock writeLock;

    public FsConcurrentController(FsController<? extends FsConcurrentModel> controller) {
        super(controller);
    }

    @Override
    protected ReentrantReadWriteLock.ReadLock readLock() {
        ReentrantReadWriteLock.ReadLock readLock = this.readLock;
        return null != readLock ? readLock : (this.readLock = ((FsConcurrentModel)this.getModel()).readLock());
    }

    @Override
    protected ReentrantReadWriteLock.WriteLock writeLock() {
        ReentrantReadWriteLock.WriteLock writeLock = this.writeLock;
        return null != writeLock ? writeLock : (this.writeLock = ((FsConcurrentModel)this.getModel()).writeLock());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Icon getOpenIcon() throws IOException {
        this.readLock().lock();
        try {
            Icon icon = this.delegate.getOpenIcon();
            this.readLock().unlock();
            return icon;
        }
        catch (Throwable throwable) {
            try {
                this.readLock().unlock();
                throw throwable;
            }
            catch (FsNotWriteLockedException ex) {
                this.assertNotReadLockedByCurrentThread(ex);
                this.writeLock().lock();
                try {
                    Icon icon = this.delegate.getOpenIcon();
                    return icon;
                }
                finally {
                    this.writeLock().unlock();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Icon getClosedIcon() throws IOException {
        this.readLock().lock();
        try {
            Icon icon = this.delegate.getClosedIcon();
            this.readLock().unlock();
            return icon;
        }
        catch (Throwable throwable) {
            try {
                this.readLock().unlock();
                throw throwable;
            }
            catch (FsNotWriteLockedException ex) {
                this.assertNotReadLockedByCurrentThread(ex);
                this.writeLock().lock();
                try {
                    Icon icon = this.delegate.getClosedIcon();
                    return icon;
                }
                finally {
                    this.writeLock().unlock();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isReadOnly() throws IOException {
        this.readLock().lock();
        try {
            boolean bl = this.delegate.isReadOnly();
            this.readLock().unlock();
            return bl;
        }
        catch (Throwable throwable) {
            try {
                this.readLock().unlock();
                throw throwable;
            }
            catch (FsNotWriteLockedException ex) {
                this.assertNotReadLockedByCurrentThread(ex);
                this.writeLock().lock();
                try {
                    boolean bl = this.delegate.isReadOnly();
                    return bl;
                }
                finally {
                    this.writeLock().unlock();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FsEntry getEntry(FsEntryName name) throws IOException {
        this.readLock().lock();
        try {
            FsEntry fsEntry = this.delegate.getEntry(name);
            this.readLock().unlock();
            return fsEntry;
        }
        catch (Throwable throwable) {
            try {
                this.readLock().unlock();
                throw throwable;
            }
            catch (FsNotWriteLockedException ex) {
                this.assertNotReadLockedByCurrentThread(ex);
                this.writeLock().lock();
                try {
                    FsEntry fsEntry = this.delegate.getEntry(name);
                    return fsEntry;
                }
                finally {
                    this.writeLock().unlock();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isReadable(FsEntryName name) throws IOException {
        this.readLock().lock();
        try {
            boolean bl = this.delegate.isReadable(name);
            this.readLock().unlock();
            return bl;
        }
        catch (Throwable throwable) {
            try {
                this.readLock().unlock();
                throw throwable;
            }
            catch (FsNotWriteLockedException ex) {
                this.assertNotReadLockedByCurrentThread(ex);
                this.writeLock().lock();
                try {
                    boolean bl = this.delegate.isReadable(name);
                    return bl;
                }
                finally {
                    this.writeLock().unlock();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isWritable(FsEntryName name) throws IOException {
        this.readLock().lock();
        try {
            boolean bl = this.delegate.isWritable(name);
            this.readLock().unlock();
            return bl;
        }
        catch (Throwable throwable) {
            try {
                this.readLock().unlock();
                throw throwable;
            }
            catch (FsNotWriteLockedException ex) {
                this.assertNotReadLockedByCurrentThread(ex);
                this.writeLock().lock();
                try {
                    boolean bl = this.delegate.isWritable(name);
                    return bl;
                }
                finally {
                    this.writeLock().unlock();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setReadOnly(FsEntryName name) throws IOException {
        this.assertNotReadLockedByCurrentThread(null);
        this.writeLock().lock();
        try {
            this.delegate.setReadOnly(name);
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setTime(FsEntryName name, Map<Entry.Access, Long> times, BitField<FsOutputOption> options) throws IOException {
        this.assertNotReadLockedByCurrentThread(null);
        this.writeLock().lock();
        try {
            boolean bl = this.delegate.setTime(name, times, options);
            return bl;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setTime(FsEntryName name, BitField<Entry.Access> types, long value, BitField<FsOutputOption> options) throws IOException {
        this.assertNotReadLockedByCurrentThread(null);
        this.writeLock().lock();
        try {
            boolean bl = this.delegate.setTime(name, types, value, options);
            return bl;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    @Override
    public InputSocket<?> getInputSocket(FsEntryName name, BitField<FsInputOption> options) {
        return CONCURRENT_SOCKET_FACTORY.newInputSocket(this, this.delegate.getInputSocket(name, options));
    }

    @Override
    public OutputSocket<?> getOutputSocket(FsEntryName name, BitField<FsOutputOption> options, Entry template) {
        return CONCURRENT_SOCKET_FACTORY.newOutputSocket(this, this.delegate.getOutputSocket(name, options, template));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mknod(@NonNull FsEntryName name, @NonNull Entry.Type type, @NonNull BitField<FsOutputOption> options, @CheckForNull Entry template) throws IOException {
        this.assertNotReadLockedByCurrentThread(null);
        this.writeLock().lock();
        try {
            this.delegate.mknod(name, type, options, template);
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlink(FsEntryName name, BitField<FsOutputOption> options) throws IOException {
        this.assertNotReadLockedByCurrentThread(null);
        this.writeLock().lock();
        try {
            FsController<?> parent;
            this.delegate.unlink(name, options);
            if (name.isRoot() && null != (parent = this.getParent())) {
                parent.unlink(this.getMountPoint().getPath().resolve(name).getEntryName(), options);
            }
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <X extends IOException> void sync(@NonNull BitField<FsSyncOption> options, @NonNull ExceptionHandler<? super FsSyncException, X> handler) throws X {
        this.writeLock().lock();
        try {
            this.delegate.sync(options, handler);
        }
        finally {
            this.writeLock().unlock();
        }
    }

    private final class ConcurrentOutputStream
    extends DecoratingOutputStream {
        ConcurrentOutputStream(OutputStream out) {
            super(out);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            FsConcurrentController.this.assertNotReadLockedByCurrentThread(null);
            FsConcurrentController.this.writeLock().lock();
            try {
                this.delegate.close();
            }
            finally {
                FsConcurrentController.this.writeLock().unlock();
            }
        }
    }

    private final class ConcurrentInputStream
    extends DecoratingInputStream {
        ConcurrentInputStream(InputStream in) {
            super(in);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            FsConcurrentController.this.assertNotReadLockedByCurrentThread(null);
            FsConcurrentController.this.writeLock().lock();
            try {
                this.delegate.close();
            }
            finally {
                FsConcurrentController.this.writeLock().unlock();
            }
        }
    }

    private final class ConcurrentSeekableByteChannel
    extends DecoratingSeekableByteChannel {
        ConcurrentSeekableByteChannel(SeekableByteChannel sbc) {
            super(sbc);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            FsConcurrentController.this.assertNotReadLockedByCurrentThread(null);
            FsConcurrentController.this.writeLock().lock();
            try {
                this.delegate.close();
            }
            finally {
                FsConcurrentController.this.writeLock().unlock();
            }
        }
    }

    private final class ConcurrentReadOnlyFile
    extends DecoratingReadOnlyFile {
        ConcurrentReadOnlyFile(ReadOnlyFile rof) {
            super(rof);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            FsConcurrentController.this.assertNotReadLockedByCurrentThread(null);
            FsConcurrentController.this.writeLock().lock();
            try {
                this.delegate.close();
            }
            finally {
                FsConcurrentController.this.writeLock().unlock();
            }
        }
    }

    private class Output
    extends DecoratingOutputSocket<Entry> {
        Output(OutputSocket<?> output) {
            super(output);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Entry getLocalTarget() throws IOException {
            FsConcurrentController.this.assertNotReadLockedByCurrentThread(null);
            FsConcurrentController.this.writeLock().lock();
            try {
                Entry entry = (Entry)this.getBoundSocket().getLocalTarget();
                return entry;
            }
            finally {
                FsConcurrentController.this.writeLock().unlock();
            }
        }

        @Override
        public Entry getPeerTarget() throws IOException {
            return this.getBoundSocket().getPeerTarget();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public OutputStream newOutputStream() throws IOException {
            FsConcurrentController.this.assertNotReadLockedByCurrentThread(null);
            FsConcurrentController.this.writeLock().lock();
            try {
                ConcurrentOutputStream concurrentOutputStream = new ConcurrentOutputStream(this.getBoundSocket().newOutputStream());
                return concurrentOutputStream;
            }
            finally {
                FsConcurrentController.this.writeLock().unlock();
            }
        }
    }

    private final class Nio2Output
    extends Output {
        Nio2Output(OutputSocket<?> output) {
            super(output);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SeekableByteChannel newSeekableByteChannel() throws IOException {
            FsConcurrentController.this.assertNotReadLockedByCurrentThread(null);
            FsConcurrentController.this.writeLock().lock();
            try {
                ConcurrentSeekableByteChannel concurrentSeekableByteChannel = new ConcurrentSeekableByteChannel(this.getBoundSocket().newSeekableByteChannel());
                return concurrentSeekableByteChannel;
            }
            finally {
                FsConcurrentController.this.writeLock().unlock();
            }
        }
    }

    private class Input
    extends DecoratingInputSocket<Entry> {
        Input(InputSocket<?> input) {
            super(input);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Entry getLocalTarget() throws IOException {
            FsConcurrentController.this.readLock().lock();
            try {
                Entry entry = (Entry)this.getBoundSocket().getLocalTarget();
                FsConcurrentController.this.readLock().unlock();
                return entry;
            }
            catch (Throwable throwable) {
                try {
                    FsConcurrentController.this.readLock().unlock();
                    throw throwable;
                }
                catch (FsNotWriteLockedException ex) {
                    FsConcurrentController.this.assertNotReadLockedByCurrentThread(ex);
                    FsConcurrentController.this.writeLock().lock();
                    try {
                        Entry entry = (Entry)this.getBoundSocket().getLocalTarget();
                        return entry;
                    }
                    finally {
                        FsConcurrentController.this.writeLock().unlock();
                    }
                }
            }
        }

        @Override
        public Entry getPeerTarget() throws IOException {
            return this.getBoundSocket().getPeerTarget();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ReadOnlyFile newReadOnlyFile() throws IOException {
            FsConcurrentController.this.assertNotReadLockedByCurrentThread(null);
            FsConcurrentController.this.writeLock().lock();
            try {
                ConcurrentReadOnlyFile concurrentReadOnlyFile = new ConcurrentReadOnlyFile(this.getBoundSocket().newReadOnlyFile());
                return concurrentReadOnlyFile;
            }
            finally {
                FsConcurrentController.this.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public InputStream newInputStream() throws IOException {
            FsConcurrentController.this.assertNotReadLockedByCurrentThread(null);
            FsConcurrentController.this.writeLock().lock();
            try {
                ConcurrentInputStream concurrentInputStream = new ConcurrentInputStream(this.getBoundSocket().newInputStream());
                return concurrentInputStream;
            }
            finally {
                FsConcurrentController.this.writeLock().unlock();
            }
        }
    }

    private final class Nio2Input
    extends Input {
        Nio2Input(InputSocket<?> input) {
            super(input);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SeekableByteChannel newSeekableByteChannel() throws IOException {
            FsConcurrentController.this.assertNotReadLockedByCurrentThread(null);
            FsConcurrentController.this.writeLock().lock();
            try {
                ConcurrentSeekableByteChannel concurrentSeekableByteChannel = new ConcurrentSeekableByteChannel(this.getBoundSocket().newSeekableByteChannel());
                return concurrentSeekableByteChannel;
            }
            finally {
                FsConcurrentController.this.writeLock().unlock();
            }
        }
    }

    @Immutable
    private static enum ConcurrentSocketFactory {
        OIO{

            @Override
            InputSocket<?> newInputSocket(FsConcurrentController controller, InputSocket<?> input) {
                FsConcurrentController fsConcurrentController = controller;
                fsConcurrentController.getClass();
                return fsConcurrentController.new Input(input);
            }

            @Override
            OutputSocket<?> newOutputSocket(FsConcurrentController controller, OutputSocket<?> output) {
                FsConcurrentController fsConcurrentController = controller;
                fsConcurrentController.getClass();
                return fsConcurrentController.new Output(output);
            }
        }
        ,
        NIO2{

            @Override
            InputSocket<?> newInputSocket(FsConcurrentController controller, InputSocket<?> input) {
                FsConcurrentController fsConcurrentController = controller;
                fsConcurrentController.getClass();
                return fsConcurrentController.new Nio2Input(input);
            }

            @Override
            OutputSocket<?> newOutputSocket(FsConcurrentController controller, OutputSocket<?> output) {
                FsConcurrentController fsConcurrentController = controller;
                fsConcurrentController.getClass();
                return fsConcurrentController.new Nio2Output(output);
            }
        };


        abstract InputSocket<?> newInputSocket(FsConcurrentController var1, InputSocket<?> var2);

        abstract OutputSocket<?> newOutputSocket(FsConcurrentController var1, OutputSocket<?> var2);
    }
}

