/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.archive;

import de.schlichtherle.truezip.fs.FsConcurrentModel;
import de.schlichtherle.truezip.fs.FsFalsePositiveException;
import de.schlichtherle.truezip.fs.archive.FsArchiveController;
import de.schlichtherle.truezip.fs.archive.FsArchiveEntry;
import de.schlichtherle.truezip.fs.archive.FsArchiveFileSystem;
import de.schlichtherle.truezip.fs.archive.FsCacheableFalsePositiveException;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
@DefaultAnnotation(value={NonNull.class})
abstract class FsFileSystemArchiveController<E extends FsArchiveEntry>
extends FsArchiveController<E> {
    private MountState<E> mountState = new ResetFileSystem();

    FsFileSystemArchiveController(FsConcurrentModel model) {
        super(model);
    }

    @Override
    final FsArchiveFileSystem<E> autoMount(boolean autoCreate) throws IOException {
        return this.mountState.autoMount(autoCreate);
    }

    @Nullable
    final FsArchiveFileSystem<E> getFileSystem() {
        return this.mountState.getFileSystem();
    }

    final void setFileSystem(@CheckForNull FsArchiveFileSystem<E> fileSystem) {
        this.mountState.setFileSystem(fileSystem);
    }

    abstract void mount(boolean var1) throws IOException;

    private final class FalsePositiveFileSystem
    extends MountState<E> {
        private FsCacheableFalsePositiveException exception;

        private FalsePositiveFileSystem(FsCacheableFalsePositiveException exception) {
            if (exception == null) {
                throw new NullPointerException();
            }
            this.exception = exception;
        }

        @Override
        FsArchiveFileSystem<E> autoMount(boolean autoCreate) throws FsFalsePositiveException {
            throw this.exception;
        }

        @Override
        void setFileSystem(FsArchiveFileSystem<E> fileSystem) {
            FsFileSystemArchiveController.this.mountState = null != fileSystem ? new MountedFileSystem(fileSystem) : new ResetFileSystem();
        }
    }

    private final class MountedFileSystem
    extends MountState<E> {
        private final FsArchiveFileSystem<E> fileSystem;

        MountedFileSystem(FsArchiveFileSystem<E> fileSystem) {
            if (fileSystem == null) {
                throw new NullPointerException();
            }
            this.fileSystem = fileSystem;
        }

        @Override
        FsArchiveFileSystem<E> autoMount(boolean autoCreate) {
            return this.fileSystem;
        }

        @Override
        FsArchiveFileSystem<E> getFileSystem() {
            return this.fileSystem;
        }

        @Override
        void setFileSystem(FsArchiveFileSystem<E> fileSystem) {
            if (fileSystem != null) {
                throw new IllegalArgumentException("File system already mounted!");
            }
            FsFileSystemArchiveController.this.mountState = new ResetFileSystem();
        }
    }

    private final class ResetFileSystem
    extends MountState<E> {
        private ResetFileSystem() {
        }

        @Override
        FsArchiveFileSystem<E> autoMount(boolean autoCreate) throws IOException {
            FsFileSystemArchiveController.this.assertWriteLockedByCurrentThread();
            try {
                FsFileSystemArchiveController.this.mount(autoCreate);
            }
            catch (FsCacheableFalsePositiveException ex) {
                FsFileSystemArchiveController.this.mountState = new FalsePositiveFileSystem(ex);
            }
            assert (this != FsFileSystemArchiveController.this.mountState);
            return FsFileSystemArchiveController.this.mountState.autoMount(autoCreate);
        }

        @Override
        void setFileSystem(FsArchiveFileSystem<E> fileSystem) {
            if (fileSystem != null) {
                FsFileSystemArchiveController.this.mountState = new MountedFileSystem(fileSystem);
            }
        }
    }

    private static abstract class MountState<E extends FsArchiveEntry> {
        private MountState() {
        }

        abstract FsArchiveFileSystem<E> autoMount(boolean var1) throws IOException;

        @Nullable
        FsArchiveFileSystem<E> getFileSystem() {
            return null;
        }

        abstract void setFileSystem(@CheckForNull FsArchiveFileSystem<E> var1);
    }
}

