/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.booter.remote.xml;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.xebialabs.deployit.booter.remote.DeployitCommunicator;
import com.xebialabs.deployit.booter.remote.RemoteBooter;
import com.xebialabs.deployit.booter.remote.RemotePropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xltype.serialization.xstream.Converters;
import com.xebialabs.xltype.serialization.xstream.XStreamProvider;
import java.util.List;

@XStreamProvider(tagName="property-descriptor", readable=PropertyDescriptor.class)
public class PropertyDescriptorConverter
implements Converter {
    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        throw new IllegalStateException("Cannot serialize PropertyDescriptor from remote-booter");
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        String booterConfigKey = (String)context.get((Object)"BOOTER_CONFIG");
        DeployitCommunicator communicator = RemoteBooter.getCommunicator(booterConfigKey);
        RemotePropertyDescriptor pd = new RemotePropertyDescriptor();
        this.setAttributes(pd, reader);
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            if ("referencedType".equals(reader.getNodeName())) {
                pd.setReferencedType(communicator.getType(reader.getValue()));
            } else if ("defaultValue".equals(reader.getNodeName())) {
                pd.setDefaultValue(reader.getValue());
            } else if ("enumValues".equals(reader.getNodeName())) {
                reader.moveDown();
                List strings = Converters.readList((Object)pd, String.class, (HierarchicalStreamReader)reader, (UnmarshallingContext)context);
                reader.moveUp();
                pd.setEnumValues(strings);
            }
            reader.moveUp();
        }
        return pd;
    }

    private void setAttributes(RemotePropertyDescriptor pd, HierarchicalStreamReader reader) {
        pd.setName(reader.getAttribute("name"));
        pd.setFqn(reader.getAttribute("fqn"));
        pd.setLabel(reader.getAttribute("label"));
        pd.setKind(PropertyKind.valueOf((String)reader.getAttribute("kind")));
        pd.setDescription(reader.getAttribute("description"));
        pd.setCategory(reader.getAttribute("category"));
        if ("true".equalsIgnoreCase(reader.getAttribute("asContainment"))) {
            pd.setAsContainment();
        }
        if ("true".equalsIgnoreCase(reader.getAttribute("required"))) {
            pd.setRequired();
        }
        if ("true".equalsIgnoreCase(reader.getAttribute("inspection"))) {
            pd.setInspectionProperty();
        }
        if ("true".equalsIgnoreCase(reader.getAttribute("requiredInspection"))) {
            pd.setRequiredInspection();
        }
        if ("true".equalsIgnoreCase(reader.getAttribute("password"))) {
            pd.setPassword();
        }
        if ("true".equalsIgnoreCase(reader.getAttribute("transient"))) {
            pd.setTransient();
        }
        if (null != reader.getAttribute("size")) {
            pd.setSize(Property.Size.valueOf((String)reader.getAttribute("size")));
        }
    }

    public boolean canConvert(Class type) {
        return PropertyDescriptor.class.equals((Object)type);
    }
}

