/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.io.swing;

import de.schlichtherle.truezip.swing.AbstractComboBoxBrowser;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.File;
import java.io.FilenameFilter;
import java.text.Collator;
import java.util.Arrays;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.filechooser.FileSystemView;

@DefaultAnnotation(value={NonNull.class})
public class FileComboBoxBrowser
extends AbstractComboBoxBrowser<String> {
    private static final long serialVersionUID = -6878885832542209810L;
    @CheckForNull
    private transient FileSystemView fileSystemView;
    @CheckForNull
    private transient File directory;

    public FileComboBoxBrowser() {
        this(null, null);
    }

    public FileComboBoxBrowser(@CheckForNull JComboBox<String> comboBox) {
        this(comboBox, null);
    }

    public FileComboBoxBrowser(@CheckForNull FileSystemView fileSystemView) {
        this(null, fileSystemView);
    }

    public FileComboBoxBrowser(@CheckForNull JComboBox<String> comboBox, @CheckForNull FileSystemView fileSystemView) {
        super(comboBox);
        Object item;
        this.fileSystemView = fileSystemView;
        if (null != comboBox && (null == (item = comboBox.getSelectedItem()) || item instanceof String)) {
            this.update0((String)item);
        }
    }

    public File getDirectory() {
        File directory = this.directory;
        return null != directory ? directory : (this.directory = this.getFileSystemView().createFileObject("."));
    }

    public void setDirectory(@CheckForNull File directory) {
        this.directory = directory;
    }

    public FileSystemView getFileSystemView() {
        FileSystemView fileSystemView = this.fileSystemView;
        return null != fileSystemView ? fileSystemView : (this.fileSystemView = FileSystemView.getFileSystemView());
    }

    public void setFileSystemView(@CheckForNull FileSystemView fileSystemView) {
        this.fileSystemView = fileSystemView;
    }

    @Override
    protected boolean update(@CheckForNull String initials) {
        return this.update0(initials);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean update0(@CheckForNull String initials) {
        String prefix;
        String base;
        File dir = this.getDirectory();
        if (null == initials) {
            initials = "";
        }
        if ("".equals(initials)) {
            base = "";
            prefix = "";
        } else {
            File node = this.getFileSystemView().createFileObject(initials);
            if (node.isAbsolute()) {
                boolean dirPath;
                boolean bl = dirPath = node.getPath().length() < initials.length();
                if (dirPath && node.isDirectory()) {
                    dir = node;
                    prefix = "";
                } else {
                    dir = node.getParentFile();
                    if (dir == null) {
                        dir = node;
                        prefix = "";
                    } else {
                        prefix = node.getName();
                    }
                }
                base = dir.getPath().endsWith(File.separator) ? initials.substring(0, dir.getPath().length()) : initials.substring(0, dir.getPath().length() + 1);
            } else {
                boolean dirPath;
                File directory = dir;
                node = this.getFileSystemView().createFileObject(directory, initials);
                boolean bl = dirPath = node.getPath().length() < (directory.getPath() + File.separator + initials).length();
                if (dirPath && node.isDirectory()) {
                    dir = node;
                    prefix = "";
                } else {
                    dir = node.getParentFile();
                    assert (dir != null) : "node is child of directory";
                    prefix = node.getName();
                }
                base = initials.substring(0, dir.getPath().length() - directory.getPath().length());
            }
        }
        class Filter
        implements FilenameFilter {
            final int pl;

            Filter() {
                this.pl = prefix.length();
            }

            @Override
            public boolean accept(File d, String child) {
                if (child.length() >= this.pl) {
                    return prefix.equalsIgnoreCase(child.substring(0, this.pl));
                }
                return false;
            }
        }
        Filter filter = new Filter();
        String[] children = dir.list(filter);
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.getComboBox().getModel();
        try {
            int l;
            model.removeAllElements();
            int n = l = children != null ? children.length : 0;
            if (l > 0) {
                Arrays.sort(children, Collator.getInstance());
                for (int i = 0; i < l; ++i) {
                    model.addElement(base + children[i]);
                }
                boolean bl = true;
                return bl;
            }
            model.addElement(initials);
            boolean bl = false;
            return bl;
        }
        finally {
            if (!initials.equals(model.getSelectedItem())) {
                model.setSelectedItem(initials);
            }
        }
    }
}

