/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.jcr;

import java.util.HashSet;
import javax.jcr.Session;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JcrDavSession
implements DavSession {
    private static Logger log = LoggerFactory.getLogger(JcrDavSession.class);
    private final Session session;
    private final HashSet<String> lockTokens = new HashSet();

    protected JcrDavSession(Session session) {
        this.session = session;
    }

    public static void checkImplementation(DavSession davSession) throws DavException {
        if (!(davSession instanceof JcrDavSession)) {
            throw new DavException(500, "JCR specific DavSession expected. Found: " + davSession);
        }
    }

    public static Session getRepositorySession(DavSession davSession) throws DavException {
        JcrDavSession.checkImplementation(davSession);
        return ((JcrDavSession)davSession).getRepositorySession();
    }

    public Session getRepositorySession() {
        return this.session;
    }

    public void addLockToken(String token) {
        this.session.addLockToken(JcrDavSession.getJCRLockToken(token));
        this.lockTokens.add(token);
    }

    public String[] getLockTokens() {
        return this.lockTokens.toArray(new String[this.lockTokens.size()]);
    }

    public void removeLockToken(String token) {
        this.session.removeLockToken(JcrDavSession.getJCRLockToken(token));
        this.lockTokens.remove(token);
    }

    private static String getJCRLockToken(String token) {
        if (token.startsWith("opaquelocktoken:")) {
            return token.substring("opaquelocktoken:".length());
        }
        return token;
    }
}

