/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.importer;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.DeploymentPackage;
import com.xebialabs.deployit.server.api.importer.ImportSource;
import com.xebialabs.deployit.server.api.importer.ImportedPackage;
import com.xebialabs.deployit.server.api.importer.ImportingContext;
import com.xebialabs.deployit.server.api.importer.ListableImporter;
import com.xebialabs.deployit.server.api.importer.PackageInfo;
import com.xebialabs.deployit.service.importer.PackageScanner;
import com.xebialabs.deployit.service.importer.reader.DeployableConfigurationItemReader;
import com.xebialabs.deployit.service.importer.reader.DeployitJarManifest;
import com.xebialabs.deployit.service.importer.reader.ManifestEntry;
import com.xebialabs.deployit.util.GuavaFiles;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManifestBasedDarImporter
implements ListableImporter {
    public static final String TEMPORARY_FILES = "temporaryFiles";
    private static final Logger logger = LoggerFactory.getLogger(ManifestBasedDarImporter.class);

    public List<String> list(File directory) {
        ArrayList packages = Lists.newArrayList(PackageScanner.scan(directory));
        Collections.sort(packages);
        return packages;
    }

    public boolean canHandle(ImportSource source) {
        File file = source.getFile();
        return PackageScanner.isDarPackage(file) || PackageScanner.isExplodedPackage(file);
    }

    public PackageInfo preparePackage(ImportSource source, ImportingContext ctx) {
        PackageInfo packageInfo = new PackageInfo(source);
        ManifestBasedDarImporter.updatePackageInfoWithManifestValues(packageInfo);
        ctx.setAttribute(TEMPORARY_FILES, (Object)Lists.newArrayList());
        return packageInfo;
    }

    private static void updatePackageInfoWithManifestValues(PackageInfo packageInfo) {
        DeployitJarManifest manifest = ManifestBasedDarImporter.getManifest(packageInfo);
        packageInfo.setApplicationName(manifest.getApplicationName());
        packageInfo.setApplicationVersion(manifest.getApplicationVersion());
    }

    public ImportedPackage importEntities(PackageInfo packageInfo, ImportingContext ctx) {
        ImportedPackage importedPackage = new ImportedPackage(packageInfo);
        DeployitJarManifest manifest = ManifestBasedDarImporter.getManifest(packageInfo);
        ManifestBasedDarImporter.createDeployableEntities(packageInfo, manifest, importedPackage, ctx);
        return importedPackage;
    }

    private static void createDeployableEntities(PackageInfo packageInfo, DeployitJarManifest manifest, ImportedPackage importedPackage, ImportingContext ctx) {
        DeployableConfigurationItemReader reader = new DeployableConfigurationItemReader(manifest);
        for (ManifestEntry entry : manifest.getEntries()) {
            if (reader.isEmbedded(entry)) continue;
            if (reader.isMiddlewareResource(entry)) {
                importedPackage.addDeployable(reader.readMiddlewareConfiguration((DeploymentPackage)importedPackage.getVersion(), entry));
                continue;
            }
            importedPackage.addDeployable((Deployable)reader.readArtifact((DeploymentPackage)importedPackage.getVersion(), packageInfo.getSource(), entry, ctx));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DeployitJarManifest getManifest(PackageInfo packageInfo) {
        TFile manifestFileForUnpackedPackage = PackageScanner.getManifestFileFromImportSource(packageInfo.getSource());
        try {
            DeployitJarManifest deployitJarManifest = DeployitJarManifest.readFromFile(manifestFileForUnpackedPackage);
            return deployitJarManifest;
        }
        finally {
            ManifestBasedDarImporter.umountSource(packageInfo);
        }
    }

    private static void umountSource(PackageInfo packageInfo) {
        try {
            TFile.umount((TFile)new TFile(packageInfo.getSource().getFile()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void cleanUp(PackageInfo packageInfo, ImportingContext ctx) {
        List files = (List)ctx.getAttribute(TEMPORARY_FILES);
        for (TFile file : files) {
            logger.debug("Cleaning up temporary file {}", (Object)file);
            try {
                File javaFile = file.getFile();
                if (javaFile.isDirectory()) {
                    GuavaFiles.deleteRecursively(javaFile);
                    continue;
                }
                if (javaFile.delete()) continue;
                logger.info("Couldn't delete file: {}", (Object)javaFile);
            }
            catch (IOException e) {
                logger.error("Couldn't clean up file {}", (Object)file, (Object)e);
            }
        }
        ManifestBasedDarImporter.umountSource(packageInfo);
    }
}

