/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.booter.local;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.booter.local.LocalDescriptor;
import com.xebialabs.deployit.booter.local.LocalDescriptorRegistry;
import com.xebialabs.deployit.booter.local.SyntheticHelper;
import com.xebialabs.deployit.booter.local.utils.ReflectionUtils;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

class TypeDefinitions {
    private final Map<Type, TypeDefinition> typeDefs = Maps.newHashMap();
    private static final Logger logger = LoggerFactory.getLogger(TypeDefinitions.class);

    TypeDefinitions() {
    }

    void defineType(Class clazz) {
        ClassBasedTypeDefinition typeDef = new ClassBasedTypeDefinition(clazz);
        this.typeDefs.put(typeDef.type, typeDef);
        logger.debug("Found: {}", (Object)typeDef);
    }

    void defineType(Element element) {
        SyntheticBasedTypeDefinition typeDef = new SyntheticBasedTypeDefinition(element);
        this.typeDefs.put(typeDef.type, typeDef);
        logger.debug("Found: {}", (Object)typeDef);
    }

    void defineGeneratedType(Element element, Element owner) {
        GeneratedTypeDefinition typeDef = new GeneratedTypeDefinition(owner, element);
        this.typeDefs.put(typeDef.type, typeDef);
        logger.debug("Found: {}", (Object)typeDef);
    }

    void modifyType(Element element) {
        Type toBeModified = SyntheticHelper.getRequiredTypeAttribute(element, "type");
        Preconditions.checkState((boolean)this.typeDefs.containsKey(toBeModified), (String)"Detected type-modification for non-existing type [%s]", (Object[])new Object[]{toBeModified});
        this.typeDefs.get((Object)toBeModified).typeModifications.push(element);
        logger.debug("Registering type modification for: {}", (Object)toBeModified);
    }

    Collection<TypeDefinition> getDefinitions() {
        return Lists.newArrayList(this.typeDefs.values());
    }

    TypeDefinition getDefinition(Type type) {
        return this.typeDefs.get(type);
    }

    private static Type type(Class clazz) {
        if (clazz != null && ConfigurationItem.class.isAssignableFrom(clazz)) {
            return Type.valueOf((Class)clazz);
        }
        return null;
    }

    class GeneratedTypeDefinition
    extends SyntheticBasedTypeDefinition {
        Type owner;

        private GeneratedTypeDefinition(Element owner, Element generatedElement) {
            super(generatedElement);
            this.owner = SyntheticHelper.getRequiredTypeAttribute(owner, "type");
        }

        @Override
        void register(TypeDefinitions typeDefinitions) {
            if (LocalDescriptorRegistry.exists((Type)this.type)) {
                return;
            }
            if (!LocalDescriptorRegistry.exists((Type)this.owner)) {
                typeDefinitions.getDefinition(this.owner).register(typeDefinitions);
            }
            if (this.parent != null && !LocalDescriptorRegistry.exists((Type)this.parent)) {
                typeDefinitions.getDefinition(this.parent).register(typeDefinitions);
            }
            LocalDescriptor descriptor = LocalDescriptor.from((LocalDescriptor)LocalDescriptorRegistry.getDescriptor((Type)this.owner));
            LocalDescriptorRegistry.register(descriptor);
            this.applyTypeModifications(descriptor);
        }
    }

    class SyntheticBasedTypeDefinition
    extends TypeDefinition {
        private Element element;

        public SyntheticBasedTypeDefinition(Element element) {
            this.element = element;
            this.type = SyntheticHelper.getRequiredTypeAttribute(element, "type");
            this.parent = SyntheticHelper.getRequiredTypeAttribute(element, "extends");
        }

        @Override
        void register(TypeDefinitions typeDefinitions) {
            if (LocalDescriptorRegistry.exists((Type)this.type)) {
                return;
            }
            if (this.parent != null && !LocalDescriptorRegistry.exists((Type)this.parent)) {
                typeDefinitions.getDefinition(this.parent).register(typeDefinitions);
            }
            LocalDescriptor descriptor = LocalDescriptor.from(this.element);
            LocalDescriptorRegistry.register(descriptor);
            this.applyTypeModifications(descriptor);
        }
    }

    class ClassBasedTypeDefinition
    extends TypeDefinition {
        private Class<? extends ConfigurationItem> clazz;
        private List<Type> interfaces;

        public ClassBasedTypeDefinition(Class<? extends ConfigurationItem> ci) {
            this.interfaces = Lists.newArrayList();
            this.type = TypeDefinitions.type(ci);
            this.parent = TypeDefinitions.type(ci.getSuperclass());
            this.interfaces = Lists.newArrayList((Iterable)Collections2.transform((Collection)Collections2.filter(ReflectionUtils.getAllInterfaces(ci), (Predicate)new Predicate<Class<?>>(){

                public boolean apply(Class<?> input) {
                    return TypeDefinitions.type(input) != null;
                }
            }), (Function)new Function<Class, Type>(){

                public Type apply(Class input) {
                    return TypeDefinitions.type(input);
                }
            }));
            this.clazz = ci;
        }

        @Override
        void register(TypeDefinitions typeDefinitions) {
            if (LocalDescriptorRegistry.exists((Type)this.type)) {
                return;
            }
            if (this.parent != null && !LocalDescriptorRegistry.exists((Type)this.parent)) {
                typeDefinitions.getDefinition(this.parent).register(typeDefinitions);
            }
            for (Type anInterface : this.interfaces) {
                if (LocalDescriptorRegistry.exists((Type)anInterface)) continue;
                typeDefinitions.getDefinition(anInterface).register(typeDefinitions);
            }
            LocalDescriptor descriptor = LocalDescriptor.from(this.clazz);
            LocalDescriptorRegistry.register(descriptor);
            this.applyTypeModifications(descriptor);
        }

        @Override
        protected void registerAsSubtype(Type type) {
            super.registerAsSubtype(type);
            for (Type anInterface : this.interfaces) {
                LocalDescriptorRegistry.registerSubtype(anInterface, type);
            }
        }
    }

    abstract class TypeDefinition {
        Type type;
        Type parent;
        Stack<Element> typeModifications = new Stack();

        TypeDefinition() {
        }

        public String toString() {
            return "TypeDef[" + this.type + "]";
        }

        abstract void register(TypeDefinitions var1);

        void applyTypeModifications(LocalDescriptor descriptor) {
            for (Element typeModification : this.typeModifications) {
                descriptor.parseTypeModification(typeModification);
            }
        }

        final void registerTypeTree() {
            this.registerAsSubtype(this.type);
        }

        protected void registerAsSubtype(Type type) {
            if (this.parent != null) {
                LocalDescriptorRegistry.registerSubtype(this.parent, type);
                TypeDefinitions.this.getDefinition(this.parent).registerAsSubtype(type);
            }
        }
    }
}

