/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.version.exporter;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.io.Closeables;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.DeployableArtifact;
import com.xebialabs.deployit.plugin.api.udm.DeploymentPackage;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.base.BaseDeployableArtifact;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.deployit.service.version.exporter.ManifestWriter;
import com.xebialabs.overthere.local.LocalFile;
import de.schlichtherle.truezip.file.TArchiveDetector;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TFileOutputStream;
import de.schlichtherle.truezip.fs.FsSyncException;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.jar.Manifest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ExporterService {
    private final RepositoryService repositoryService;
    private final ManifestWriter manifestWriter;
    private static Logger logger = LoggerFactory.getLogger(ExporterService.class);

    @Autowired
    public ExporterService(RepositoryService repositoryService, ManifestWriter manifestWriter) {
        this.repositoryService = repositoryService;
        this.manifestWriter = manifestWriter;
    }

    public LocalFile exportDar(String versionId, WorkDir workDir) {
        Preconditions.checkNotNull((Object)versionId, (Object)"id of the version to be exported is null");
        Object ci = this.repositoryService.read(versionId, workDir);
        Preconditions.checkArgument((boolean)ci.getType().instanceOf(Type.valueOf(DeploymentPackage.class)), (String)"Expected udm.DeploymentPackage for exporting but got %s", (Object[])new Object[]{ci.getType()});
        DeploymentPackage deploymentPackage = (DeploymentPackage)ci;
        String name = String.format("%s-%s.dar", deploymentPackage.getApplication().getName(), deploymentPackage.getVersion());
        TFile exportedDar = new TFile(workDir.getPath(), name);
        try {
            exportedDar.mkdirs();
            this.addManifestToDar(deploymentPackage, exportedDar);
            this.copyArtifactsToDar(deploymentPackage, exportedDar);
            LocalFile localFile = (LocalFile)LocalFile.valueOf((File)exportedDar.getFile());
            return localFile;
        }
        catch (Exception e) {
            throw new RuntimeException("Errors found while exporting package version", e);
        }
        finally {
            try {
                TFile.umount((TFile)exportedDar);
            }
            catch (FsSyncException ignore) {}
        }
    }

    private void addManifestToDar(DeploymentPackage deploymentPackage, TFile exportedDar) {
        TFileOutputStream out = null;
        try {
            TFile manifestFile = new TFile((File)exportedDar, "/META-INF/MANIFEST.MF");
            out = new TFileOutputStream((File)manifestFile);
            Manifest manifest = this.createManifest(deploymentPackage);
            manifest.write((OutputStream)out);
        }
        catch (Exception e) {
            try {
                throw new RuntimeException("Errors found while adding manifest file to dar", e);
            }
            catch (Throwable throwable) {
                Closeables.closeQuietly(out);
                throw throwable;
            }
        }
        Closeables.closeQuietly((Closeable)out);
    }

    private Manifest createManifest(DeploymentPackage deploymentPackage) {
        this.manifestWriter.addHeader(deploymentPackage.getApplication().getName(), deploymentPackage.getVersion());
        Set deployables = deploymentPackage.getDeployables();
        for (Deployable each : deployables) {
            Map<String, String> values = this.getPropertyValues(each);
            if (this.isMiddlewareResource((ConfigurationItem)each)) {
                this.manifestWriter.addResourceEntry(each.getName(), each.getType().toString(), values);
                continue;
            }
            BaseDeployableArtifact artifact = (BaseDeployableArtifact)each;
            values.put("Name", each.getName());
            this.manifestWriter.addArtifactEntry(artifact.getFile().getName(), each.getType().toString(), values);
        }
        Manifest manifest = this.manifestWriter.getManifest();
        return manifest;
    }

    private void copyArtifactsToDar(DeploymentPackage deploymentPackage, TFile exportedDar) throws IOException {
        Set deployables = deploymentPackage.getDeployables();
        for (Deployable each : deployables) {
            if (this.isMiddlewareResource((ConfigurationItem)each)) continue;
            BaseDeployableArtifact artifact = (BaseDeployableArtifact)each;
            File srcArtifact = new File(artifact.getFile().getPath());
            TFile destArtifact = new TFile((File)exportedDar, artifact.getFile().getName(), TArchiveDetector.NULL);
            TFile.cp_r((File)srcArtifact, (File)destArtifact, (TArchiveDetector)TArchiveDetector.NULL);
        }
    }

    private Map<String, String> getPropertyValues(Deployable ci) {
        HashMap valueMap = Maps.newHashMap();
        block7: for (PropertyDescriptor propertyDescriptor : ci.getType().getDescriptor().getPropertyDescriptors()) {
            Object value;
            if (propertyDescriptor.isHidden() || "placeholders".equals(propertyDescriptor.getName()) || (value = propertyDescriptor.get((ConfigurationItem)ci)) == null) continue;
            switch (propertyDescriptor.getKind()) {
                case BOOLEAN: 
                case INTEGER: 
                case STRING: 
                case ENUM: {
                    valueMap.put(propertyDescriptor.getName(), String.valueOf(value));
                    break;
                }
                case CI: {
                    valueMap.put(propertyDescriptor.getName(), ((BaseConfigurationItem)value).getName());
                    break;
                }
                case SET_OF_STRING: 
                case LIST_OF_STRING: {
                    int strCount = 1;
                    for (String s : (Collection)value) {
                        valueMap.put(propertyDescriptor.getName() + "-EntryValue-" + strCount++, s);
                    }
                    continue block7;
                }
                case SET_OF_CI: 
                case LIST_OF_CI: {
                    int ciCount = 1;
                    for (ConfigurationItem ciEntry : (Collection)value) {
                        valueMap.put(propertyDescriptor.getName() + "-EntryValue-" + ciCount++, ciEntry.getName());
                    }
                    continue block7;
                }
                case MAP_STRING_STRING: {
                    for (Map.Entry entry : ((Map)value).entrySet()) {
                        valueMap.put(propertyDescriptor.getName() + "-" + (String)entry.getKey(), entry.getValue());
                    }
                    break;
                }
            }
        }
        return valueMap;
    }

    private boolean isMiddlewareResource(ConfigurationItem ci) {
        return !ci.getType().getDescriptor().isAssignableTo(DeployableArtifact.class);
    }
}

