/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.jcr;

import com.xebialabs.deployit.DeployitConfiguration;
import com.xebialabs.deployit.jcr.JcrCallback;
import com.xebialabs.deployit.jcr.RuntimeRepositoryException;
import com.xebialabs.deployit.security.PermissionDeniedException;
import com.xebialabs.deployit.security.authentication.AuthenticationFailureException;
import javax.jcr.AccessDeniedException;
import javax.jcr.Credentials;
import javax.jcr.LoginException;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class JcrTemplate {
    private final Repository repository;
    private static final ThreadLocal<Session> SESSION_STORE = new ThreadLocal();
    private static final Logger logger = LoggerFactory.getLogger(JcrTemplate.class);

    @Autowired
    public JcrTemplate(Repository repository) {
        this.repository = repository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final <T> T execute(JcrCallback<T> callback) throws RuntimeRepositoryException {
        Session session = SESSION_STORE.get();
        boolean createNewSession = false;
        if (session == null) {
            logger.debug("Did not find an existing session, creating a session for one JCR request.");
            createNewSession = true;
        } else if (!session.isLive()) {
            logger.debug("Existing session is no longer live, creating a session for one JCR request.");
            createNewSession = true;
        }
        if (createNewSession) {
            try {
                SimpleCredentials credentials = new SimpleCredentials("admin", DeployitConfiguration.getInstance().getAdminPassword().toCharArray());
                session = this.repository.login((Credentials)credentials);
                try {
                    T t = callback.doInJcr(session);
                    return t;
                }
                finally {
                    session.logout();
                }
            }
            catch (AccessDeniedException ade) {
                throw PermissionDeniedException.withMessage("Failed to complete your request.", (Exception)((Object)ade));
            }
            catch (LoginException le) {
                throw new AuthenticationFailureException(le, "Incorrect credentials for user %s, did you forget to update the password in the deployit configuration file?", "admin");
            }
            catch (RepositoryException e) {
                throw new RuntimeRepositoryException(e.toString(), e);
            }
        }
        try {
            return callback.doInJcr(session);
        }
        catch (RepositoryException e) {
            throw new RuntimeRepositoryException(e.toString(), e);
        }
    }

    public void login() {
        SimpleCredentials cred = new SimpleCredentials("admin", DeployitConfiguration.getInstance().getAdminPassword().toCharArray());
        try {
            Session session = this.repository.login((Credentials)cred);
            SESSION_STORE.set(session);
        }
        catch (AccessDeniedException ade) {
            throw PermissionDeniedException.withMessage("Failed to complete your request.", (Exception)((Object)ade));
        }
        catch (LoginException le) {
            throw new AuthenticationFailureException(le, "Couldn't login to the repository", new Object[]{le});
        }
        catch (RepositoryException e) {
            throw new RuntimeRepositoryException(e.toString(), e);
        }
    }

    public boolean isLoggedIn() {
        return SESSION_STORE.get() != null && SESSION_STORE.get().isLive();
    }

    public void logout() {
        if (SESSION_STORE.get() != null) {
            SESSION_STORE.get().logout();
            SESSION_STORE.remove();
        } else {
            logger.warn("Superfluous logout call found.", (Throwable)new RuntimeException());
        }
    }
}

