/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.util;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
@DefaultAnnotation(value={NonNull.class})
public abstract class FilteringIterator<T>
implements Iterator<T> {
    private final Iterator<T> iterator;
    @CheckForNull
    private Boolean hasNext;
    @Nullable
    private T next;

    protected FilteringIterator(Iterator<T> iterator) {
        assert (null != iterator);
        this.iterator = iterator;
    }

    protected FilteringIterator(Iterable<T> iterable) {
        this.iterator = iterable.iterator();
    }

    protected abstract boolean accept(@Nullable T var1);

    @Override
    public boolean hasNext() {
        if (null != this.hasNext) {
            return this.hasNext;
        }
        while (this.iterator.hasNext()) {
            this.next = this.iterator.next();
            if (!this.accept(this.next)) continue;
            this.hasNext = true;
            return this.hasNext;
        }
        this.hasNext = false;
        return this.hasNext;
    }

    @Override
    @Nullable
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.hasNext = null;
        return this.next;
    }

    @Override
    public void remove() {
        this.iterator.remove();
    }
}

