/*
 * Decompiled with CFR 0.152.
 */
package nl.javadude.scannit.reader;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import de.schlichtherle.truezip.file.TFile;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceConfigurationError;
import nl.javadude.scannit.reader.TFiles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArchiveEntrySupplier {
    private final URI uri;
    private static final Logger logger = LoggerFactory.getLogger(ArchiveEntrySupplier.class);

    public ArchiveEntrySupplier(URI uri) {
        this.uri = uri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void withArchiveEntries(Predicate<TFile> with) {
        TFile tFile = TFiles.tFile(this.uri);
        try {
            List<TFile> entries = this.list(tFile);
            for (TFile file : entries) {
                with.apply((Object)file);
            }
        }
        finally {
            this.closeTFile(tFile);
        }
    }

    protected void closeTFile(TFile tFile) {
        TFiles.umountQuietly(tFile);
    }

    private List<TFile> list(TFile tFile) {
        ArrayList entries = Lists.newArrayList();
        if (tFile.isArchive()) {
            this.gatherEntries(tFile, entries, true);
        } else {
            this.gatherEntries(tFile, entries, false);
        }
        return entries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void gatherEntries(TFile tFile, List<TFile> files, boolean scanInArchives) {
        try {
            boolean hasFiles;
            boolean isArchive = tFile.isArchive();
            boolean isNormalDir = !isArchive && tFile.isDirectory();
            boolean bl = hasFiles = (isArchive || isNormalDir) && tFile.listFiles() != null;
            if (isNormalDir && hasFiles || isArchive && scanInArchives && hasFiles) {
                logger.trace("Listing directory/archive of file: {}", (Object)tFile);
                for (TFile file : tFile.listFiles()) {
                    this.gatherEntries(file, files, false);
                }
            } else if (tFile.isFile() || tFile.isEntry()) {
                logger.trace("Found file/entry {}", (Object)tFile);
                files.add(tFile);
            }
        }
        catch (RuntimeException re) {
            logger.error("Error scanning {}, continuing...", (Object)tFile);
            logger.debug("Exception was: ", (Throwable)re);
        }
        catch (ServiceConfigurationError re) {
            logger.error("Error scanning {}, continuing...", (Object)tFile);
            logger.debug("Error was: ", (Throwable)re);
        }
        finally {
            this.closeTFile(tFile);
        }
    }
}

