/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.booter.remote.xml;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.xebialabs.deployit.booter.remote.RemoteDescriptor;
import com.xebialabs.deployit.engine.xml.Converters;
import com.xebialabs.deployit.engine.xml.XStreamProvider;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.MethodDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XStreamProvider(tagName="descriptor", readable=Descriptor.class)
public class DescriptorConverter
implements Converter {
    private static final Logger logger = LoggerFactory.getLogger(DescriptorConverter.class);

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        throw new IllegalStateException("Cannot serialize Descriptors from remote-booter");
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        RemoteDescriptor descriptor = new RemoteDescriptor();
        this.setAttributes(reader, descriptor);
        while (reader.hasMoreChildren()) {
            List list;
            reader.moveDown();
            if ("description".equals(reader.getNodeName())) {
                descriptor.setDescription(reader.getValue());
            } else if ("property-descriptors".equals(reader.getNodeName())) {
                list = Converters.readList((Object)descriptor, PropertyDescriptor.class, (HierarchicalStreamReader)reader, (UnmarshallingContext)context);
                descriptor.setPropertyDescriptors(list);
            } else if ("control-tasks".equals(reader.getNodeName())) {
                list = Converters.readList((Object)descriptor, MethodDescriptor.class, (HierarchicalStreamReader)reader, (UnmarshallingContext)context);
                descriptor.setControlTasks(list);
            } else if ("interfaces".equals(reader.getNodeName())) {
                HashSet interfaces = Sets.newHashSet();
                while (reader.hasMoreChildren()) {
                    reader.moveDown();
                    interfaces.add(Type.valueOf((String)reader.getValue()));
                    reader.moveUp();
                }
                descriptor.setInterfaces(interfaces);
            } else if ("superTypes".equals(reader.getNodeName())) {
                ArrayList superTypes = Lists.newArrayList();
                while (reader.hasMoreChildren()) {
                    reader.moveDown();
                    superTypes.add(Type.valueOf((String)reader.getValue()));
                    reader.moveUp();
                }
                descriptor.setSuperTypes(superTypes);
            }
            reader.moveUp();
        }
        return descriptor;
    }

    private void setAttributes(HierarchicalStreamReader reader, RemoteDescriptor descriptor) {
        String inspectable;
        String virtual;
        String containerType;
        descriptor.setType(Type.valueOf((String)reader.getAttribute("type")));
        String deployableType = reader.getAttribute("deployableType");
        if (deployableType != null) {
            descriptor.setDeployableType(Type.valueOf((String)deployableType));
        }
        if ((containerType = reader.getAttribute("containerType")) != null) {
            descriptor.setContainerType(Type.valueOf((String)containerType));
        }
        if ("true".equalsIgnoreCase(virtual = reader.getAttribute("virtual"))) {
            descriptor.setVirtual();
        }
        if ("true".equalsIgnoreCase(inspectable = reader.getAttribute("inspectable"))) {
            descriptor.setInspectable();
        }
        descriptor.setRoot(this.readRoot(reader));
    }

    private Metadata.ConfigurationItemRoot readRoot(HierarchicalStreamReader reader) {
        String rootNodeName = reader.getAttribute("root");
        if (rootNodeName == null) {
            return Metadata.ConfigurationItemRoot.NESTED;
        }
        for (Metadata.ConfigurationItemRoot configurationItemRoot : Metadata.ConfigurationItemRoot.values()) {
            if (!rootNodeName.equals(configurationItemRoot.getRootNodeName())) continue;
            return configurationItemRoot;
        }
        return null;
    }

    public boolean canConvert(Class type) {
        return type.equals(Descriptor.class);
    }
}

