/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.task.archive;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.engine.api.execution.StepExecutionState;
import com.xebialabs.deployit.engine.api.execution.StepState;
import com.xebialabs.deployit.engine.api.execution.TaskExecutionState;
import com.xebialabs.deployit.engine.api.execution.TaskWithSteps;
import com.xebialabs.deployit.engine.tasker.Archive;
import com.xebialabs.deployit.engine.tasker.TaskNotFoundException;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.jcr.JcrCallback;
import com.xebialabs.deployit.jcr.JcrTemplate;
import com.xebialabs.deployit.jcr.JcrUtils;
import com.xebialabs.deployit.jcr.grouping.GroupBy;
import com.xebialabs.deployit.task.ArchivedTaskSearchParameters;
import com.xebialabs.deployit.task.TaskType;
import com.xebialabs.deployit.task.archive.ArchivedStep;
import com.xebialabs.deployit.task.archive.ArchivedTask;
import com.xebialabs.deployit.task.archive.JcrArchivedTaskSearchQueryBuilder;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.jcr.query.RowIterator;
import javax.jcr.query.qom.QueryObjectModel;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class JcrTaskArchive
implements Archive {
    public static final String ENVIRONMENTS_ROOT = "Environments/";
    static final String STATE = "state";
    static final String START_DATE = "startDate";
    static final String COMPLETION_DATE = "completionDate";
    static final String LAST_MODIFICATION_DATE = "lastModificationDate";
    static final String NR_OF_STEPS = "nrOfSteps";
    static final String CURRENT_STEP_NR = "currentStepNr";
    static final String OWNING_USER = "ownerUser";
    static final String FAILURE_COUNT = "failureCount";
    static final String LOG = "log";
    static final String DESCRIPTION = "description";
    static final String APPLICATION = "application";
    static final String VERSION = "version";
    static final String ENVIRONMENT_NAME = "environment";
    static final String ENVIRONMENT_ID = "environment_id";
    static final String DEPLOYMENT_TYPE = "deploymentType";
    private final JcrTemplate jcrTemplate;
    private static final Pattern qualifiedTaskIdPattern = Pattern.compile("^(.*)/(.*)/(.*)/(.*)$");
    private final Set<String> EXCLUDE_SPECIAL_ENV_TASK_NAMES = Sets.newHashSet((Object[])new String[]{"Environments/" + (Object)((Object)TaskType.INSPECTION), "Environments/" + (Object)((Object)TaskType.CONTROL), "Environments/rep:policy"});

    @Autowired
    public JcrTaskArchive(JcrTemplate jcrTemplate) {
        this.jcrTemplate = jcrTemplate;
    }

    public void archive(TaskWithSteps task) {
        if (JcrTaskArchive.isDeploymentTask(task)) {
            this.saveDeploymentTask(task);
        } else {
            this.saveTask(task);
        }
    }

    private void saveTask(final TaskWithSteps task) {
        this.jcrTemplate.execute(new JcrCallback<String>(){

            @Override
            public String doInJcr(Session session) throws RepositoryException {
                Node jcrTaskNode = JcrTaskArchive.createTaskNode(task, JcrTaskArchive.getTasksRootNode(session));
                JcrTaskArchive.fillTaskNode(jcrTaskNode, task);
                session.save();
                return null;
            }
        });
    }

    private void saveDeploymentTask(final TaskWithSteps task) {
        JcrTaskArchive.checkDeploymentTask(task);
        this.jcrTemplate.execute(new JcrCallback<String>(){

            @Override
            public String doInJcr(Session session) throws RepositoryException {
                Node jcrTaskNode = JcrTaskArchive.createDeploymentTaskNode(task, JcrTaskArchive.getTasksRootNode(session));
                JcrTaskArchive.fillDeploymentTaskNode(jcrTaskNode, task);
                session.save();
                return null;
            }
        });
    }

    private static Node createTaskNode(TaskWithSteps task, Node tasksRootNode) throws RepositoryException {
        Node taskType = JcrUtils.getOrCreateChild(tasksRootNode, (String)task.getMetadata().get("taskType"));
        Node node = taskType.addNode(task.getId());
        node.addMixin("deployit:task");
        return node;
    }

    private static Node createDeploymentTaskNode(TaskWithSteps task, Node tasksRootNode) throws RepositoryException {
        Node envNode = JcrUtils.getOrCreateChild(tasksRootNode, JcrTaskArchive.encodeEnvironmentId((String)task.getMetadata().get(ENVIRONMENT_ID)));
        Node appNode = JcrUtils.getOrCreateChild(envNode, (String)task.getMetadata().get(APPLICATION));
        Node verNode = JcrUtils.getOrCreateChild(appNode, (String)task.getMetadata().get(VERSION));
        Node node = verNode.addNode(task.getId());
        node.addMixin("deployit:task");
        return node;
    }

    private static void checkDeploymentTask(TaskWithSteps task) {
        Preconditions.checkState((!Strings.nullToEmpty((String)((String)task.getMetadata().get(APPLICATION))).isEmpty() ? 1 : 0) != 0, (Object)"applicationName in deployment task must be set");
        Preconditions.checkState((!Strings.nullToEmpty((String)((String)task.getMetadata().get(VERSION))).isEmpty() ? 1 : 0) != 0, (Object)"applicationVersion in deployment task must be set");
        Preconditions.checkState((!Strings.nullToEmpty((String)((String)task.getMetadata().get(ENVIRONMENT_NAME))).isEmpty() ? 1 : 0) != 0, (Object)"environment in deployment task must be set");
        Preconditions.checkState((!Strings.nullToEmpty((String)((String)task.getMetadata().get(ENVIRONMENT_ID))).isEmpty() ? 1 : 0) != 0, (Object)"environment_id in deployment task must be set");
    }

    static String encodeEnvironmentId(String id) {
        if (id.startsWith(ENVIRONMENTS_ROOT)) {
            id = id.substring(ENVIRONMENTS_ROOT.length());
        }
        return id.replace("/", "$#");
    }

    static String decodeEnvironmentId(String id) {
        if (!(id = id.replace("$#", "/")).startsWith(ENVIRONMENTS_ROOT)) {
            return ENVIRONMENTS_ROOT + id;
        }
        return id;
    }

    private static void fillDeploymentTaskNode(Node taskNode, TaskWithSteps task) throws RepositoryException {
        JcrTaskArchive.fillTaskNode(taskNode, task);
        taskNode.setProperty(APPLICATION, (String)task.getMetadata().get(APPLICATION));
        taskNode.setProperty(VERSION, (String)task.getMetadata().get(VERSION));
        taskNode.setProperty(ENVIRONMENT_NAME, (String)task.getMetadata().get(ENVIRONMENT_NAME));
        taskNode.setProperty(ENVIRONMENT_ID, JcrTaskArchive.encodeEnvironmentId((String)task.getMetadata().get(ENVIRONMENT_ID)));
    }

    private static void fillTaskNode(Node taskNode, TaskWithSteps task) throws RepositoryException {
        taskNode.setProperty("$id", task.getId());
        taskNode.setProperty(STATE, task.getState().name());
        taskNode.setProperty(START_DATE, (Calendar)task.getStartDate().toGregorianCalendar());
        taskNode.setProperty(COMPLETION_DATE, (Calendar)task.getCompletionDate().toGregorianCalendar());
        taskNode.setProperty(CURRENT_STEP_NR, (long)task.getCurrentStepNr());
        taskNode.setProperty(NR_OF_STEPS, (long)task.getNrSteps());
        taskNode.setProperty(OWNING_USER, task.getOwner());
        taskNode.setProperty(FAILURE_COUNT, (long)task.getFailureCount());
        taskNode.setProperty(DEPLOYMENT_TYPE, (String)task.getMetadata().get("taskType"));
        int nr = 1;
        for (StepState step : task.getSteps()) {
            Node stepNode = taskNode.addNode("step" + nr++);
            stepNode.setProperty(DESCRIPTION, step.getDescription());
            stepNode.setProperty(STATE, step.getState().name());
            stepNode.setProperty(START_DATE, step.getStartDate() == null ? null : step.getStartDate().toGregorianCalendar());
            stepNode.setProperty(COMPLETION_DATE, step.getCompletionDate() == null ? null : step.getCompletionDate().toGregorianCalendar());
            stepNode.setProperty(FAILURE_COUNT, (long)step.getFailureCount());
            stepNode.setProperty(LOG, step.getLog());
        }
    }

    private static boolean isDeploymentTask(TaskWithSteps task) {
        return EnumSet.of(TaskType.ROLLBACK, TaskType.INITIAL, TaskType.UPGRADE, TaskType.UNDEPLOY).contains((Object)TaskType.valueOf((String)task.getMetadata().get("taskType")));
    }

    public TaskWithSteps getTask(String taskId) {
        Matcher matcher = qualifiedTaskIdPattern.matcher(taskId);
        if (matcher.matches()) {
            String internalId = JcrTaskArchive.encodeEnvironmentId(matcher.group(1)) + "/" + matcher.group(2) + "/" + matcher.group(3) + "/" + matcher.group(4);
            return this.getTaskUsingFullyQualifiedPath(internalId);
        }
        return this.getTaskUsingUuid(taskId);
    }

    private TaskWithSteps getTaskUsingFullyQualifiedPath(final String fullyQualifiedPath) {
        return this.jcrTemplate.execute(new JcrCallback<ArchivedTask>(){

            @Override
            public ArchivedTask doInJcr(Session session) throws RepositoryException {
                try {
                    Node tasksNode = JcrTaskArchive.getTasksRootNode(session);
                    Node taskNode = tasksNode.getNode(fullyQualifiedPath);
                    ArchivedTask task = JcrTaskArchive.toTaskWithoutSteps(taskNode);
                    if (task == null) {
                        throw new NotFoundException("Cannot load task " + fullyQualifiedPath + " because that object with that id is not a task", new Object[0]);
                    }
                    task.setSteps(JcrTaskArchive.getSteps(taskNode));
                    return task;
                }
                catch (PathNotFoundException exc) {
                    throw new NotFoundException("Cannot load task " + fullyQualifiedPath + " because it does not exist", new Object[0]);
                }
            }
        });
    }

    private TaskWithSteps getTaskUsingUuid(String taskUuid) {
        ArchivedTaskSearchParameters taskSearch = new ArchivedTaskSearchParameters();
        taskSearch.withUniqueId(taskUuid);
        Collection<ArchivedTask> deploymentTaskInfos = this.searchTasks(taskSearch);
        if (deploymentTaskInfos.size() == 1) {
            return deploymentTaskInfos.iterator().next();
        }
        if (deploymentTaskInfos.isEmpty()) {
            throw new TaskNotFoundException("archive", taskUuid);
        }
        throw new NotFoundException("Cannot load task " + taskUuid + " because there are multiple tasks with same id. " + deploymentTaskInfos, new Object[0]);
    }

    private static ArchivedTask toTaskWithoutSteps(Node taskNode) throws RepositoryException {
        if (!taskNode.isNodeType("deployit:task")) {
            return null;
        }
        ArchivedTask task = new ArchivedTask();
        task.setId(JcrUtils.getProperty(taskNode, "$id"));
        task.getMetadata().put("taskType", JcrUtils.getProperty(taskNode, DEPLOYMENT_TYPE));
        task.setState(TaskExecutionState.valueOf((String)JcrUtils.getProperty(taskNode, STATE)));
        task.setStartDate(JcrUtils.getDate(taskNode, START_DATE));
        task.setCompletionDate(JcrUtils.getDate(taskNode, COMPLETION_DATE));
        task.setOwner(JcrUtils.getOptionalProperty(taskNode, OWNING_USER));
        task.setCurrentStepNr(JcrUtils.getIntegerProperty(taskNode, CURRENT_STEP_NR));
        task.setFailureCount(JcrUtils.getIntegerProperty(taskNode, FAILURE_COUNT));
        if (JcrTaskArchive.isDeploymentTask(task)) {
            task.getMetadata().put(ENVIRONMENT_NAME, JcrUtils.getProperty(taskNode, ENVIRONMENT_NAME));
            if (taskNode.hasProperty(ENVIRONMENT_ID)) {
                task.getMetadata().put(ENVIRONMENT_ID, JcrTaskArchive.decodeEnvironmentId(JcrUtils.getProperty(taskNode, ENVIRONMENT_ID)));
            } else {
                task.getMetadata().put(ENVIRONMENT_ID, JcrTaskArchive.decodeEnvironmentId(JcrUtils.getProperty(taskNode, ENVIRONMENT_NAME)));
            }
            task.getMetadata().put(APPLICATION, JcrUtils.getProperty(taskNode, APPLICATION));
            task.getMetadata().put(VERSION, JcrUtils.getProperty(taskNode, VERSION));
        }
        return task;
    }

    private static List<StepState> getSteps(Node taskNode) throws RepositoryException {
        int nrOfSteps = JcrUtils.getIntegerProperty(taskNode, NR_OF_STEPS);
        ArrayList steps = Lists.newArrayList();
        for (int nr = 1; nr <= nrOfSteps; ++nr) {
            Node stepNode = taskNode.getNode("step" + nr);
            steps.add(JcrTaskArchive.toStep(stepNode));
        }
        return steps;
    }

    private static ArchivedStep toStep(Node stepNode) throws RepositoryException {
        ArchivedStep step = new ArchivedStep();
        step.setDescription(JcrUtils.getProperty(stepNode, DESCRIPTION));
        step.setState(StepExecutionState.valueOf((String)JcrUtils.getProperty(stepNode, STATE)));
        step.setStartDate(JcrUtils.getDate(stepNode, START_DATE));
        step.setCompletionDate(JcrUtils.getDate(stepNode, COMPLETION_DATE));
        step.setLog(JcrUtils.getProperty(stepNode, LOG));
        step.setFailureCount(JcrUtils.getIntegerProperty(stepNode, FAILURE_COUNT));
        return step;
    }

    private static Node getTasksRootNode(Session session) throws RepositoryException {
        return session.getRootNode().getNode("tasks");
    }

    public Collection<ArchivedTask> searchTasks(ArchivedTaskSearchParameters params) {
        return this.searchTasks(params, true);
    }

    public Collection<ArchivedTask> searchTasksWithoutLoadingSteps(ArchivedTaskSearchParameters params) {
        return this.searchTasks(params, false);
    }

    private List<ArchivedTask> searchTasks(final ArchivedTaskSearchParameters params, final boolean loadSteps) {
        return this.jcrTemplate.execute(new JcrCallback<List<ArchivedTask>>(){

            @Override
            public List<ArchivedTask> doInJcr(Session session) throws RepositoryException {
                QueryResult queryResult = JcrTaskArchive.executeJcrQuery(session, params);
                final ArrayList tasks = Lists.newArrayList();
                JcrTaskArchive.mapQueryResultToTasks(queryResult, loadSteps, new TaskCallback(){

                    @Override
                    public void doWithTask(ArchivedTask t) {
                        tasks.add(t);
                    }
                });
                return tasks;
            }
        });
    }

    public void searchTasks(ArchivedTaskSearchParameters params, TaskCallback callback) {
        this.searchTasks(params, callback, true);
    }

    public void searchTasksWithoutLoadingSteps(ArchivedTaskSearchParameters params, TaskCallback callback) {
        this.searchTasks(params, callback, false);
    }

    private Object searchTasks(final ArchivedTaskSearchParameters params, final TaskCallback callback, final boolean loadSteps) {
        return this.jcrTemplate.execute(new JcrCallback<Object>(){

            @Override
            public Object doInJcr(Session session) throws RepositoryException {
                QueryResult queryResult = JcrTaskArchive.executeJcrQuery(session, params);
                JcrTaskArchive.mapQueryResultToTasks(queryResult, loadSteps, callback);
                return null;
            }
        });
    }

    private static QueryResult executeJcrQuery(Session session, ArchivedTaskSearchParameters params) throws RepositoryException {
        QueryManager qm = session.getWorkspace().getQueryManager();
        JcrArchivedTaskSearchQueryBuilder queryBuilder = new JcrArchivedTaskSearchQueryBuilder(qm, session.getValueFactory(), params);
        QueryObjectModel query = queryBuilder.buildQuery();
        return query.execute();
    }

    public List<String> getAllEnvironments() {
        return this.jcrTemplate.execute(new JcrCallback<List<String>>(){

            @Override
            public List<String> doInJcr(Session session) throws RepositoryException {
                ArrayList envs = Lists.newArrayList();
                NodeIterator nodes = session.getNode("/tasks").getNodes();
                while (nodes.hasNext()) {
                    String envId = JcrTaskArchive.decodeEnvironmentId(nodes.nextNode().getName());
                    if (JcrTaskArchive.this.EXCLUDE_SPECIAL_ENV_TASK_NAMES.contains(envId)) continue;
                    envs.add(envId);
                }
                return envs;
            }
        });
    }

    private static void mapQueryResultToTasks(QueryResult result, boolean loadSteps, TaskCallback callback) throws RepositoryException {
        RowIterator iterator = result.getRows();
        while (iterator.hasNext()) {
            try {
                Node taskNode = iterator.nextRow().getNode("task");
                ArchivedTask task = JcrTaskArchive.toTaskWithoutSteps(taskNode);
                if (loadSteps) {
                    task.setSteps(JcrTaskArchive.getSteps(taskNode));
                }
                callback.doWithTask(task);
            }
            catch (RepositoryException rre) {}
        }
    }

    public List<String> getAllTaskIds() {
        return this.jcrTemplate.execute(new JcrCallback<List<String>>(){

            @Override
            public List<String> doInJcr(Session session) throws RepositoryException {
                QueryResult queryResult = JcrTaskArchive.executeJcrQuery(session, new ArchivedTaskSearchParameters());
                return JcrTaskArchive.getTaskIds(queryResult);
            }
        });
    }

    private static List<String> getTaskIds(QueryResult queryResult) throws RepositoryException {
        ArrayList taskIds = Lists.newArrayList();
        RowIterator iterator = queryResult.getRows();
        while (iterator.hasNext()) {
            try {
                taskIds.add(JcrUtils.getProperty(iterator.nextRow().getNode("task"), "$id"));
            }
            catch (RepositoryException repositoryException) {}
        }
        return taskIds;
    }

    public Collection<Map<String, Object>> searchTasksWithoutLoadingSteps(final ArchivedTaskSearchParameters params, final GroupBy groupBy) {
        return (Collection)this.jcrTemplate.execute(new JcrCallback<Object>(){

            @Override
            public Collection<Map<String, Object>> doInJcr(Session session) throws RepositoryException {
                RowIterator iterator = JcrTaskArchive.executeJcrQuery(session, params).getRows();
                while (iterator.hasNext()) {
                    Node taskNode = iterator.nextRow().getNode("task");
                    groupBy.process(JcrTaskArchive.toTaskWithoutSteps(taskNode));
                }
                return groupBy.getResult();
            }
        });
    }

    public static interface TaskCallback {
        public void doWithTask(ArchivedTask var1);
    }
}

