/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.importer.reader;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.jar.Attributes;

public class ManifestEntry {
    private final String name;
    private final Attributes attributes;

    public ManifestEntry(String name, Attributes attributes) {
        this.name = name.trim();
        this.attributes = attributes;
    }

    public String getName() {
        return this.name;
    }

    public String getValue(String name) {
        return this.attributes.getValue(name);
    }

    public Map<String, String> getMap(String name) {
        String keyStart = ("CI-" + name + "-").toLowerCase();
        HashMap map = Maps.newHashMap();
        for (Map.Entry<Object, Object> entry : this.attributes.entrySet()) {
            String s = entry.getKey().toString();
            if (!s.toLowerCase().startsWith(keyStart)) continue;
            String mapKey = s.substring(keyStart.length());
            String mapValue = (String)entry.getValue();
            map.put(mapKey, mapValue);
        }
        return map;
    }

    public Collection<String> getStrings(String name) {
        String oldStyle = ("CI-" + name + "-EntryValue").toLowerCase();
        String key = ("CI-" + name).toLowerCase();
        HashSet strings = Sets.newHashSet();
        for (Map.Entry<Object, Object> attribute : this.attributes.entrySet()) {
            String entryKey = attribute.getKey().toString().toLowerCase().trim();
            if (!entryKey.startsWith(oldStyle) && !entryKey.equals(key)) continue;
            strings.add(attribute.getValue().toString());
        }
        return strings;
    }
}

