/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.deployment;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.core.EncryptedStringValue;
import com.xebialabs.deployit.core.MapStringStringView;
import com.xebialabs.deployit.core.StringValue;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.server.api.util.IdGenerator;
import com.xebialabs.deployit.service.deployment.TagMatcher;
import com.xebialabs.deployit.service.deployment.TypeCalculator;
import com.xebialabs.deployit.service.replacement.ConsolidatedDictionary;
import com.xebialabs.deployit.service.replacement.DictionaryValueException;
import com.xebialabs.deployit.service.replacement.MustachePlaceholderScanner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DeployedGenerator {
    private RepositoryService repository;
    private TypeCalculator calculator;
    private TagMatcher tagMatcher;
    private static final Logger logger = LoggerFactory.getLogger(DeployedGenerator.class);

    @Autowired
    public DeployedGenerator(RepositoryService repository, TypeCalculator calculator, TagMatcher tagMatcher) {
        this.calculator = calculator;
        this.repository = repository;
        this.tagMatcher = tagMatcher;
    }

    public Deployed<?, ?> createMostSpecificDeployed(Deployable deployable, Container container, ConsolidatedDictionary dictionary) {
        return this.generateMostSpecificDeployed(deployable, container, dictionary, true);
    }

    public Deployed<?, ?> generateMostSpecificDeployed(Deployable deployable, Container container, ConsolidatedDictionary dictionary) {
        return this.generateMostSpecificDeployed(deployable, container, dictionary, false);
    }

    private Deployed<?, ?> generateMostSpecificDeployed(Deployable deployable, Container container, ConsolidatedDictionary dictionary, boolean manualAction) {
        Type deployedType = this.calculator.findMostSpecificDeployedTypeForDeployableAndContainerTypes(deployable.getType(), container.getType());
        if (deployedType != null && (manualAction || this.tagMatcher.areMatching(deployable, container))) {
            return this.generateDeployed(deployable, container, deployedType, dictionary);
        }
        return null;
    }

    public Deployed<?, ?> generateDeployed(Deployable deployable, Container container, Type deployedType, ConsolidatedDictionary dictionary) {
        Deployed<Deployable, Container> deployed = this.basicDeployed(deployable, container, deployedType);
        this.setPropertyPlaceholders(deployed, deployable, dictionary);
        this.setFilePlaceholders(deployed, deployable, dictionary);
        return deployed;
    }

    private Deployed<Deployable, Container> basicDeployed(Deployable deployable, Container container, Type deployedType) {
        Descriptor deployedDesc = DescriptorRegistry.getDescriptor((Type)deployedType);
        Deployed deployed = (Deployed)deployedDesc.newInstance();
        deployed.setDeployable(deployable);
        deployed.setContainer(container);
        IdGenerator.generateId((Deployed)deployed);
        return deployed;
    }

    private void setPropertyPlaceholders(Deployed<Deployable, Container> deployed, Deployable deployable, ConsolidatedDictionary dictionary) {
        Descriptor deployedDesc = deployed.getType().getDescriptor();
        Descriptor deployableDesc = deployable.getType().getDescriptor();
        for (PropertyDescriptor deployedPropDesc : deployedDesc.getPropertyDescriptors()) {
            String name = deployedPropDesc.getName();
            if (name.equals("placeholders")) continue;
            PropertyDescriptor deployablePropDesc = deployableDesc.getPropertyDescriptor(name);
            if (deployablePropDesc == null) {
                this.setDeployedFromDictionary(deployed, dictionary, deployedPropDesc, null);
                continue;
            }
            Object deployablePropertyValue = deployablePropDesc.get((ConfigurationItem)deployable);
            if (this.isNullOrEmpty(deployablePropertyValue, deployablePropDesc)) {
                this.setDeployedFromDictionary(deployed, dictionary, deployedPropDesc, deployablePropDesc);
                continue;
            }
            try {
                Object deployedPropertyValue = dictionary.resolve(deployablePropertyValue, deployablePropDesc);
                this.checkWhetherValueIsSecureAndPropertyIsPassword(deployedPropertyValue, deployedPropDesc, deployablePropertyValue);
                deployedPropertyValue = this.convertIfNeeded(deployedPropertyValue, deployablePropDesc, deployedPropDesc);
                deployedPropDesc.set(deployed, deployedPropertyValue);
            }
            catch (DictionaryValueException exc) {
                logger.info("Could not resolve dictionary keys for property " + deployablePropDesc + " on " + deployed + ". Property will be left empty.");
                logger.trace("Exception was", (Throwable)exc);
            }
            catch (RuntimeException exc) {
                logger.warn("Could not convert (resolved) value to correct type for property " + deployablePropDesc + " on " + deployed + ". Property will be left empty.");
                logger.trace("Exception was", (Throwable)exc);
            }
        }
    }

    private void checkWhetherValueIsSecureAndPropertyIsPassword(Object value, PropertyDescriptor deployedDesc, Object deployablePropertyValue) throws DictionaryValueException {
        if (value instanceof EncryptedStringValue && !deployedDesc.isPassword()) {
            logger.warn("The deployable value [{}] resolved to an encrypted value, but property [{}] is not a password field.", deployablePropertyValue, (Object)deployedDesc.getFqn());
            throw new DictionaryValueException("The deployable value [%s] resolved to an encrypted value, but property [%s] is not a password field.", deployablePropertyValue, deployedDesc.getFqn());
        }
    }

    private boolean isNullOrEmpty(Object value, PropertyDescriptor deployablePropDesc) {
        if (value == null) {
            return true;
        }
        switch (deployablePropDesc.getKind()) {
            case BOOLEAN: 
            case INTEGER: 
            case STRING: 
            case ENUM: 
            case CI: {
                return Strings.isNullOrEmpty((String)value.toString());
            }
            case SET_OF_STRING: 
            case SET_OF_CI: 
            case LIST_OF_STRING: 
            case LIST_OF_CI: {
                return ((Collection)value).isEmpty();
            }
            case MAP_STRING_STRING: {
                return ((Map)value).isEmpty();
            }
        }
        throw new IllegalArgumentException("Unsupported property kind: " + deployablePropDesc.getKind() + " for property: " + deployablePropDesc.getFqn());
    }

    private void setDeployedFromDictionary(Deployed<Deployable, Container> deployed, ConsolidatedDictionary dictionary, PropertyDescriptor deployedPropDesc, PropertyDescriptor deployablePropDesc) {
        if (dictionary.containsKey(deployedPropDesc.getFqn())) {
            Object value = dictionary.get(deployedPropDesc.getFqn());
            value = this.convertIfNeeded(value, deployablePropDesc, deployedPropDesc);
            deployedPropDesc.set(deployed, value);
        }
    }

    private void setFilePlaceholders(Deployed<Deployable, Container> deployed, Deployable deployable, ConsolidatedDictionary dictionary) {
        Descriptor deployedDesc = DescriptorRegistry.getDescriptor((Type)deployed.getType());
        Descriptor deployableDesc = DescriptorRegistry.getDescriptor((Type)deployable.getType());
        PropertyDescriptor deployedPlaceholdersDesc = deployedDesc.getPropertyDescriptor("placeholders");
        if (deployedPlaceholdersDesc != null) {
            PropertyDescriptor deployableplaceholders = deployableDesc.getPropertyDescriptor("placeholders");
            Set placeholders = (Set)deployableplaceholders.get((ConfigurationItem)deployable);
            deployedPlaceholdersDesc.set(deployed, (Object)this.resolveFilePlaceholders(Maps.newHashMap(), placeholders, dictionary));
        }
    }

    public Deployed<?, ?> generateUpgradedDeployed(Deployable newDeployable, Deployed<?, ?> existingDeployed, ConsolidatedDictionary dictionary) {
        Deployed<?, ?> upgradedDeployed = this.createUpgradedDeployed(newDeployable, existingDeployed);
        this.setUpgradedPropertyPlaceholders(upgradedDeployed, newDeployable, existingDeployed, dictionary);
        this.setUpgradedFilePlaceholders(upgradedDeployed, newDeployable, existingDeployed, dictionary);
        return upgradedDeployed;
    }

    private Deployed<?, ?> createUpgradedDeployed(Deployable newDeployable, Deployed<?, ?> existingDeployed) {
        Type newDeployableType;
        Descriptor deployedDesc = DescriptorRegistry.getDescriptor((Type)existingDeployed.getType());
        Type deployableType = deployedDesc.getDeployableType();
        Checks.checkArgument(deployableType.equals((Object)(newDeployableType = newDeployable.getType())) || DescriptorRegistry.getSubtypes((Type)deployableType).contains(newDeployableType), "The new Deployable type %s should be assignable to %s", newDeployableType, deployableType);
        Deployed upgradedDeployed = (Deployed)deployedDesc.newInstance();
        upgradedDeployed.setDeployable(newDeployable);
        upgradedDeployed.setContainer(existingDeployed.getContainer());
        upgradedDeployed.setId(existingDeployed.getId());
        return upgradedDeployed;
    }

    private void setUpgradedPropertyPlaceholders(Deployed<?, ?> upgradedDeployed, Deployable newDeployable, Deployed<?, ?> existingDeployed, ConsolidatedDictionary dictionary) {
        Descriptor deployedDesc = upgradedDeployed.getType().getDescriptor();
        Descriptor existingDeployableDesc = existingDeployed.getDeployable().getType().getDescriptor();
        Descriptor newDeployableDesc = newDeployable.getType().getDescriptor();
        for (PropertyDescriptor deployedPropDesc : deployedDesc.getPropertyDescriptors()) {
            Object resolvedOldDeployableValue;
            String name = deployedPropDesc.getName();
            if (name.equals("placeholders") || name.equals("deployable") || name.equals("container")) continue;
            Object oldDeployedValue = deployedPropDesc.get(existingDeployed);
            PropertyDescriptor existingDeployablePropDesc = existingDeployableDesc.getPropertyDescriptor(name);
            Object oldDeployableValue = null;
            if (existingDeployablePropDesc != null) {
                oldDeployableValue = existingDeployablePropDesc.get((ConfigurationItem)existingDeployed.getDeployable());
            }
            PropertyDescriptor newDeployablePropDesc = newDeployableDesc.getPropertyDescriptor(name);
            Object newDeployableValue = null;
            if (newDeployablePropDesc != null) {
                newDeployableValue = newDeployablePropDesc.get((ConfigurationItem)newDeployable);
            }
            Object valueToSet = oldDeployedValue;
            PropertyDescriptor valueToSetPropDesc = deployedPropDesc;
            if (oldDeployableValue != null && MustachePlaceholderScanner.hasPlaceholders(oldDeployableValue.toString())) {
                valueToSet = newDeployableValue;
                valueToSetPropDesc = newDeployablePropDesc;
            } else if (oldDeployableValue == null && newDeployableValue != null) {
                valueToSet = newDeployableValue;
                valueToSetPropDesc = newDeployablePropDesc;
            } else if (oldDeployableValue != null && (resolvedOldDeployableValue = this.convertIfNeeded(oldDeployableValue, existingDeployablePropDesc, deployedPropDesc)).toString().equals(oldDeployedValue.toString())) {
                valueToSet = newDeployableValue;
                valueToSetPropDesc = newDeployablePropDesc;
            }
            try {
                valueToSet = dictionary.resolve(valueToSet, valueToSetPropDesc);
                valueToSet = this.convertIfNeeded(valueToSet, valueToSetPropDesc, deployedPropDesc);
            }
            catch (DictionaryValueException exc) {
                valueToSet = oldDeployedValue;
                logger.info("Could not resolve dictionary keys for property " + deployedPropDesc + " of " + upgradedDeployed + ". Property will be set to old value.");
                logger.trace("Exception was: ", (Throwable)exc);
            }
            try {
                deployedPropDesc.set(upgradedDeployed, valueToSet);
            }
            catch (RuntimeException exc) {
                logger.error("Could not convert (resolved) value to correct type for property " + deployedPropDesc + " of " + upgradedDeployed + ". Property will be left empty.", (Throwable)exc);
            }
        }
    }

    private Object convertIfNeeded(Object valueToSet, PropertyDescriptor deployablePropDesc, PropertyDescriptor deployedPropDesc) {
        if (valueToSet == null) {
            return valueToSet;
        }
        if (this.optionalKind(deployablePropDesc, PropertyKind.STRING) && deployedPropDesc.getKind() == PropertyKind.CI) {
            return this.repository.read(valueToSet.toString());
        }
        if (this.optionalKind(deployablePropDesc, PropertyKind.SET_OF_STRING) && deployedPropDesc.getKind() == PropertyKind.SET_OF_CI) {
            return Sets.newHashSet(this.getCollectionOfCis(valueToSet));
        }
        if (this.optionalKind(deployablePropDesc, PropertyKind.LIST_OF_STRING) && deployedPropDesc.getKind() == PropertyKind.LIST_OF_CI) {
            return Lists.newArrayList(this.getCollectionOfCis(valueToSet));
        }
        if (deployedPropDesc.getKind() == PropertyKind.STRING) {
            if (deployedPropDesc instanceof EncryptedStringValue && !deployedPropDesc.isPassword()) {
                logger.warn("Going to write a Encrypted value as plaintext in [{}], as it is not a password field.", (Object)deployedPropDesc);
            }
            return valueToSet.toString();
        }
        if (valueToSet instanceof StringValue) {
            return valueToSet.toString();
        }
        return valueToSet;
    }

    private boolean optionalKind(PropertyDescriptor deployablePropDesc, PropertyKind kind) {
        return deployablePropDesc == null || deployablePropDesc.getKind() == kind;
    }

    private Collection<ConfigurationItem> getCollectionOfCis(Object valueToSet) {
        ArrayList cis = Lists.newArrayList();
        for (String s : (Collection)valueToSet) {
            cis.add(this.repository.read(s));
        }
        return cis;
    }

    private void setUpgradedFilePlaceholders(Deployed<?, ?> upgradedDeployed, Deployable newDeployable, Deployed<?, ?> existingDeployed, ConsolidatedDictionary dictionary) {
        Descriptor deployedDesc = DescriptorRegistry.getDescriptor((Type)upgradedDeployed.getType());
        Descriptor deployableDesc = DescriptorRegistry.getDescriptor((Type)newDeployable.getType());
        PropertyDescriptor deployedPlaceholdersDesc = deployedDesc.getPropertyDescriptor("placeholders");
        if (deployedPlaceholdersDesc != null) {
            Map existingDeployedPlaceholders = (Map)deployedPlaceholdersDesc.get(existingDeployed);
            Set newDeployablePlaceholders = (Set)deployableDesc.getPropertyDescriptor("placeholders").get((ConfigurationItem)newDeployable);
            deployedPlaceholdersDesc.set(upgradedDeployed, (Object)this.resolveFilePlaceholders(existingDeployedPlaceholders, newDeployablePlaceholders, dictionary));
        }
    }

    private MapStringStringView resolveFilePlaceholders(Map<String, String> existingDeployedPlaceholders, Set<String> deployableFilePlaceholders, ConsolidatedDictionary dictionary) {
        MapStringStringView newDeployedPlaceholders = new MapStringStringView();
        for (String deployableFilePlaceholder : deployableFilePlaceholders) {
            StringValue placeholderValue = dictionary.resolveScannedPlaceholder(deployableFilePlaceholder);
            if (placeholderValue == null) {
                placeholderValue = existingDeployedPlaceholders.containsKey(deployableFilePlaceholder) ? new StringValue(existingDeployedPlaceholders.get(deployableFilePlaceholder)) : new StringValue("");
            }
            newDeployedPlaceholders.put(deployableFilePlaceholder, placeholderValue);
        }
        return newDeployedPlaceholders;
    }
}

