/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.deployment;

import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.DeltaSpecification;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;
import com.xebialabs.deployit.repository.ChangeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeSetBuilder {
    private static final Logger logger = LoggerFactory.getLogger(ChangeSetBuilder.class);

    public static ChangeSet determineChanges(DeltaSpecification specification) {
        ChangeSet changeSet = new ChangeSet();
        ChangeSetBuilder.addDeployedApplication(changeSet, specification);
        for (Delta delta : specification.getDeltas()) {
            switch (delta.getOperation()) {
                case CREATE: {
                    changeSet.create((ConfigurationItem)delta.getDeployed());
                    specification.getDeployedApplication().addDeployed(delta.getDeployed());
                    logger.debug("The CI {} will be {} in the repository", (Object)delta.getDeployed().getId(), (Object)delta.getOperation());
                    break;
                }
                case MODIFY: 
                case NOOP: {
                    changeSet.update((ConfigurationItem)delta.getDeployed());
                    specification.getDeployedApplication().addDeployed(delta.getDeployed());
                    logger.debug("The CI {} will be {} in the repository", (Object)delta.getDeployed().getId(), (Object)delta.getOperation());
                    break;
                }
                case DESTROY: {
                    changeSet.delete((ConfigurationItem)delta.getPrevious());
                    logger.debug("The CI {} will be {} in the repository", (Object)delta.getPrevious().getId(), (Object)delta.getOperation());
                }
            }
        }
        logger.debug("DeployedApplication {} will contain the following deployeds {}", (Object)specification.getDeployedApplication(), (Object)specification.getDeployedApplication().getDeployeds());
        return changeSet;
    }

    private static void addDeployedApplication(ChangeSet changeSet, DeltaSpecification specification) {
        DeployedApplication deployedApplication = specification.getDeployedApplication();
        switch (specification.getOperation()) {
            case CREATE: {
                changeSet.create((ConfigurationItem)deployedApplication);
                break;
            }
            case MODIFY: {
                changeSet.update((ConfigurationItem)deployedApplication);
                break;
            }
            case DESTROY: {
                changeSet.delete((ConfigurationItem)deployedApplication);
                break;
            }
        }
    }
}

