/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.repository;

import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import com.xebialabs.deployit.engine.spi.command.CreateCiCommand;
import com.xebialabs.deployit.engine.spi.command.CreateCisCommand;
import com.xebialabs.deployit.engine.spi.command.DeleteCiCommand;
import com.xebialabs.deployit.engine.spi.command.DeleteCisCommand;
import com.xebialabs.deployit.engine.spi.command.UpdateCiCommand;
import com.xebialabs.deployit.engine.spi.command.UpdateCisCommand;
import com.xebialabs.deployit.engine.spi.command.util.Update;
import com.xebialabs.deployit.engine.spi.event.DeployitEventListener;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.RepositoryServiceHolder;
import java.util.List;
import nl.javadude.t2bus.Subscribe;

@DeployitEventListener
public class RepositoryEventListener {
    @Subscribe
    public void receiveCreate(CreateCiCommand command) {
        RepositoryServiceHolder.getRepositoryService().create(new ConfigurationItem[]{command.getCi()});
    }

    @Subscribe
    public void receiveCreate(CreateCisCommand command) {
        List cis = command.getCis();
        RepositoryServiceHolder.getRepositoryService().create(cis.toArray(new ConfigurationItem[cis.size()]));
    }

    @Subscribe
    public void receiveUpdate(UpdateCiCommand command) {
        RepositoryServiceHolder.getRepositoryService().update(new ConfigurationItem[]{command.getUpdate().getNewCi()});
    }

    @Subscribe
    public void receiveUpdate(UpdateCisCommand command) {
        List updates = command.getUpdates();
        FluentIterable transform = FluentIterable.from((Iterable)updates).transform((Function)new Function<Update, ConfigurationItem>(){

            public ConfigurationItem apply(Update input) {
                return input.getNewCi();
            }
        });
        RepositoryServiceHolder.getRepositoryService().update((ConfigurationItem[])transform.toArray(ConfigurationItem.class));
    }

    @Subscribe
    public void receiveDelete(DeleteCiCommand command) {
        RepositoryServiceHolder.getRepositoryService().delete(command.getCi().getId());
    }

    @Subscribe
    public void receiveDelete(DeleteCisCommand command) {
        List updates = command.getCis();
        FluentIterable transform = FluentIterable.from((Iterable)updates).transform((Function)new Function<ConfigurationItem, String>(){

            public String apply(ConfigurationItem input) {
                return input.getId();
            }
        });
        RepositoryServiceHolder.getRepositoryService().delete((String[])transform.toArray(String.class));
    }
}

