/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.repository;

import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Closeables;
import com.xebialabs.deployit.core.AbstractStringView;
import com.xebialabs.deployit.core.MapStringStringView;
import com.xebialabs.deployit.core.StringValue;
import com.xebialabs.deployit.exception.RuntimeIOException;
import com.xebialabs.deployit.io.Imploder;
import com.xebialabs.deployit.jcr.JcrUtils;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.artifact.Artifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.FolderArtifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.SourceArtifact;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.deployit.repository.ItemConflictException;
import com.xebialabs.deployit.repository.JcrPathHelper;
import com.xebialabs.deployit.repository.StringValueConverter;
import com.xebialabs.deployit.util.PasswordEncrypter;
import com.xebialabs.overthere.OverthereFile;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import org.apache.jackrabbit.value.ReferenceValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NodeWriter {
    private final Session session;
    private final ConfigurationItem item;
    private final Node node;
    private boolean basicsWritten = false;
    private final PasswordEncrypter passwordEncrypter;
    private static final Logger logger = LoggerFactory.getLogger(NodeWriter.class);

    NodeWriter(Session session, ConfigurationItem item, Node node, PasswordEncrypter passwordEncrypter) {
        this.session = session;
        this.item = item;
        this.node = node;
        this.passwordEncrypter = passwordEncrypter;
    }

    void writeBasics() throws RepositoryException {
        this.node.setProperty("$configuration.item.type", this.item.getType().toString());
        if (this.item instanceof BaseConfigurationItem) {
            String token = ((BaseConfigurationItem)this.item).get$token();
            if (Strings.isNullOrEmpty((String)token) || this.node.hasProperty("$token") && this.node.getProperty("$token").getString().equals(token)) {
                this.node.setProperty("$token", UUID.randomUUID().toString());
            } else {
                throw new ItemConflictException("Repository entity [%s] has been updated since you read it. Please reload the CI from the repository again.", this.item.getId());
            }
        }
        this.basicsWritten = true;
    }

    void write() throws RepositoryException {
        if (!this.basicsWritten) {
            this.writeBasics();
        }
        this.copyData();
        this.copyValuesIntoNode();
        this.copyMetadata();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyData() throws RepositoryException {
        OverthereFile file;
        if (this.item instanceof SourceArtifact && (file = ((Artifact)this.item).getFile()) != null) {
            InputStream dataInput;
            this.node.setProperty("$filename", file.getName());
            if (this.item instanceof FolderArtifact && file.isDirectory()) {
                try {
                    byte[] implode = Imploder.implode(file);
                    dataInput = new ByteArrayInputStream(implode);
                }
                catch (IOException e) {
                    throw new RuntimeIOException("Could not zip up the data in file " + file);
                }
            } else {
                dataInput = file.getInputStream();
            }
            try {
                Binary binary = this.session.getValueFactory().createBinary(dataInput);
                this.node.setProperty("$data", binary);
            }
            finally {
                Closeables.closeQuietly((Closeable)dataInput);
            }
        }
    }

    private void copyValuesIntoNode() throws RepositoryException {
        Descriptor ciDescriptor = DescriptorRegistry.getDescriptor((Type)this.item.getType());
        Collection propertyDescriptors = Collections2.filter((Collection)ciDescriptor.getPropertyDescriptors(), (Predicate)new Predicate<PropertyDescriptor>(){

            public boolean apply(PropertyDescriptor input) {
                return !input.isTransient();
            }
        });
        block9: for (PropertyDescriptor pd : propertyDescriptors) {
            if (pd.get(this.item) == null) {
                this.removePropertyFromNode(pd);
                continue;
            }
            logger.trace("Writing property [{}] with value [{}]", (Object)pd.getFqn(), pd.isPassword() ? "********" : pd.get(this.item));
            switch (pd.getKind()) {
                case BOOLEAN: 
                case INTEGER: 
                case STRING: 
                case ENUM: {
                    this.copyPrimitivePropertyIntoNode(pd);
                    continue block9;
                }
                case SET_OF_STRING: {
                    this.copyCollectionOfStringsPropertyIntoNode(pd);
                    continue block9;
                }
                case SET_OF_CI: {
                    this.copyCollectionOfConfigurationItemsPropertyIntoNode(pd);
                    continue block9;
                }
                case LIST_OF_STRING: {
                    this.copyCollectionOfStringsPropertyIntoNode(pd);
                    continue block9;
                }
                case LIST_OF_CI: {
                    this.copyCollectionOfConfigurationItemsPropertyIntoNode(pd);
                    continue block9;
                }
                case CI: {
                    this.copyConfigurationItemPropertyIntoNode(pd);
                    continue block9;
                }
                case MAP_STRING_STRING: {
                    this.copyMapPropertyIntoNode(pd);
                    continue block9;
                }
            }
            throw new IllegalArgumentException("Cannot convert property " + pd.getName() + " because it is of unsupported kind " + pd.getKind());
        }
    }

    private void copyMapPropertyIntoNode(PropertyDescriptor pd) throws RepositoryException {
        Map value;
        Map toWrite = value = (Map)pd.get(this.item);
        if (value instanceof MapStringStringView) {
            toWrite = Maps.transformValues(((MapStringStringView)value).getWrapped(), StringValueConverter.valueToString(this.passwordEncrypter));
        }
        JcrUtils.writeMap(this.node, pd.getName(), toWrite);
    }

    private void copyMetadata() throws RepositoryException {
        this.node.setProperty("$lastModified", Calendar.getInstance());
    }

    private void removePropertyFromNode(PropertyDescriptor pd) throws RepositoryException {
        try {
            this.node.getProperty(pd.getName()).remove();
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
    }

    private void copyPrimitivePropertyIntoNode(PropertyDescriptor pd) throws RepositoryException {
        String valueAsString = pd.get(this.item).toString();
        if (pd.getKind() == PropertyKind.STRING && pd.isPassword()) {
            valueAsString = this.passwordEncrypter.ensureEncrypted(valueAsString);
        }
        this.node.setProperty(pd.getName(), valueAsString);
    }

    private void copyCollectionOfStringsPropertyIntoNode(PropertyDescriptor pd) throws RepositoryException {
        ValueFactory valueFactory = this.session.getValueFactory();
        StringValueConverter converter = new StringValueConverter(this.passwordEncrypter);
        Collection<?> valueAsCollection = this.convertObjectValueToCollection(pd, pd.get(this.item));
        ArrayList jcrValueList = Lists.newArrayList();
        if (valueAsCollection instanceof AbstractStringView) {
            AbstractStringView view = (AbstractStringView)valueAsCollection;
            for (Object o : view.getWrapped()) {
                if (!(o instanceof StringValue)) {
                    throw new IllegalArgumentException("Element in property " + pd.getName() + " of configuration item " + this.item.getId() + " is not a StringValue: " + o);
                }
                StringValue stringValue = (StringValue)o;
                jcrValueList.add(valueFactory.createValue(converter.convert(stringValue)));
            }
        } else {
            for (Object each : valueAsCollection) {
                if (!(each instanceof String)) {
                    throw new IllegalArgumentException("Element in property " + pd.getName() + " of repository entity " + this.item.getId() + " is not a String: " + each);
                }
                String stringValue = (String)each;
                jcrValueList.add(valueFactory.createValue(stringValue));
            }
        }
        Value[] jcrValues = jcrValueList.toArray(new Value[jcrValueList.size()]);
        this.node.setProperty(pd.getName(), jcrValues);
    }

    private void copyConfigurationItemPropertyIntoNode(PropertyDescriptor pd) throws RepositoryException {
        if (pd.isAsContainment()) {
            return;
        }
        String referencedCiId = ((ConfigurationItem)pd.get(this.item)).getId();
        Node referencedCi = this.session.getNode(JcrPathHelper.getAbsolutePathFromId(referencedCiId));
        this.node.setProperty(pd.getName(), referencedCi);
    }

    private void copyCollectionOfConfigurationItemsPropertyIntoNode(PropertyDescriptor pd) throws RepositoryException {
        if (pd.isAsContainment()) {
            return;
        }
        Collection<?> valueAsCollection = this.convertObjectValueToCollection(pd, pd.get(this.item));
        ArrayList jcrReferenceList = Lists.newArrayList();
        for (Object each : valueAsCollection) {
            if (!(each instanceof ConfigurationItem)) {
                throw new IllegalArgumentException("Element in property " + pd.getName() + " of repository entity " + this.item.getId() + " is not a ConfigurationItem: " + each);
            }
            String referencedCiId = ((ConfigurationItem)each).getId();
            Node referencedCi = this.session.getNode(JcrPathHelper.getAbsolutePathFromId(referencedCiId));
            jcrReferenceList.add(new ReferenceValue(referencedCi));
        }
        Value[] jcrReferenceValues = jcrReferenceList.toArray(new Value[jcrReferenceList.size()]);
        this.node.setProperty(pd.getName(), jcrReferenceValues);
    }

    private Collection<?> convertObjectValueToCollection(PropertyDescriptor pd, Object value) {
        if (!(value instanceof Collection)) {
            throw new IllegalArgumentException("Property " + pd.getName() + " of repository entity " + this.item.getId() + " is not a Collection: " + value);
        }
        return (Collection)value;
    }
}

