/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.xebialabs.deployit.core.api.InternalSecurityProxy;
import com.xebialabs.deployit.core.api.dto.RolePermissions;
import com.xebialabs.deployit.core.api.dto.RolePrincipals;
import com.xebialabs.deployit.core.rest.api.DtoReader;
import com.xebialabs.deployit.core.rest.api.DtoWriter;
import com.xebialabs.deployit.core.rest.secured.AbstractSecuredResource;
import com.xebialabs.deployit.engine.api.security.Role;
import com.xebialabs.deployit.engine.spi.event.RolePermissionsChangedEvent;
import com.xebialabs.deployit.engine.spi.event.RolePrincipalsChangedEvent;
import com.xebialabs.deployit.engine.spi.exception.DeployitException;
import com.xebialabs.deployit.engine.spi.exception.HttpResponseCodeResult;
import com.xebialabs.deployit.event.EventBusHolder;
import com.xebialabs.deployit.security.PermissionEditor;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.deployit.security.permission.Permission;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
public class SecurityResource
extends AbstractSecuredResource
implements InternalSecurityProxy {
    @Autowired
    private RoleService roleService;
    @Autowired
    private PermissionEditor permissionEditor;
    @Autowired
    private DtoWriter dtoWriter;
    @Autowired
    private DtoReader dtoReader;
    private static final Logger logger = LoggerFactory.getLogger(SecurityResource.class);

    public List<Role> list() {
        return this.dtoWriter.writeRoles(this.roleService.getRoles());
    }

    public List<RolePermissions> readRolePermissions(String id) {
        this.checkPermission(Permission.EDIT_SECURITY);
        Multimap rolePermissionMultimap = this.permissionEditor.readPermissions(id);
        List<RolePermissions> rolePermissions = this.dtoWriter.writeRolePermissions((Multimap<com.xebialabs.deployit.security.Role, Permission>)rolePermissionMultimap);
        return rolePermissions;
    }

    public void writeRolePermissions(String id, List<RolePermissions> permissions) {
        this.checkPermission(Permission.EDIT_SECURITY);
        List roles = this.roleService.getRoles();
        Multimap<com.xebialabs.deployit.security.Role, Permission> multimap = this.dtoReader.readRolePermissions(permissions, roles);
        this.permissionEditor.editPermissions(id, multimap);
        SecurityResource.fireRolePermissionsChangedEvent(id, permissions);
    }

    private static void fireRolePermissionsChangedEvent(String id, List<RolePermissions> permissions) {
        EventBusHolder.publish((Object)new RolePermissionsChangedEvent(id, Lists.transform(permissions, (Function)new Function<RolePermissions, String>(){

            public String apply(RolePermissions input) {
                return input.getRole().getName() + " => " + input.getPermissions();
            }
        })));
    }

    public List<RolePrincipals> readRolePrincipals() {
        this.checkPermission(Permission.EDIT_SECURITY);
        List multimap = this.roleService.readRoleAssignments();
        logger.debug("RoleService delivered roles: {}", (Object)multimap);
        List<RolePrincipals> assignments = this.dtoWriter.writeRoleAssignments(multimap);
        logger.debug("Going to return the following roles: {}", assignments);
        return assignments;
    }

    public void writeRolePrincipals(List<RolePrincipals> rolePrincipals) {
        this.checkPermission(Permission.EDIT_SECURITY);
        logger.debug("Got the following roles: {}", rolePrincipals);
        List<com.xebialabs.deployit.security.Role> roles = this.dtoReader.readRoleAssignments(rolePrincipals);
        logger.debug("Going to write the following role assignments: {}", roles);
        this.roleService.writeRoleAssignments(roles);
        SecurityResource.fireRolePrincipalsChangedEvent(rolePrincipals);
    }

    private static void fireRolePrincipalsChangedEvent(List<RolePrincipals> rolePrincipals) {
        EventBusHolder.publish((Object)new RolePrincipalsChangedEvent(Lists.transform(rolePrincipals, (Function)new Function<RolePrincipals, String>(){

            public String apply(RolePrincipals input) {
                return input.getRole().getName() + " => " + input.getPrincipals();
            }
        })));
    }

    @HttpResponseCodeResult(statusCode=400)
    public static class UnknownPermissionException
    extends DeployitException {
        public UnknownPermissionException(String permission) {
            super("Permission %s does not exist.", new Object[]{permission});
        }
    }
}

