/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.deployment.planner;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.deployment.planner.Plan;
import com.xebialabs.deployit.deployment.planner.StepAdapter;
import com.xebialabs.deployit.deployment.planner.StepPlan;
import com.xebialabs.deployit.engine.spi.execution.ExecutionStateListener;
import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentStep;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.planning.ReadOnlyRepository;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;
import java.util.Collection;
import java.util.HashMap;

public class DefaultDeploymentPlanningContext
implements DeploymentPlanningContext {
    private static final Function<DeploymentStep, Step> adapt = new Function<DeploymentStep, Step>(){

        public Step apply(DeploymentStep input) {
            return StepAdapter.wrapIfNeeded(input);
        }
    };
    private final StepPlan planningResult;
    private final HashMap<String, Object> attributes = Maps.newHashMap();
    private DeployedApplication deployedApplication;
    private ReadOnlyRepository readOnlyRepository;
    private Plan plan;

    public DefaultDeploymentPlanningContext(StepPlan planningResult, DeployedApplication deployedApplication, ReadOnlyRepository readOnlyRepository, Plan plan) {
        this.planningResult = planningResult;
        this.deployedApplication = deployedApplication;
        this.readOnlyRepository = readOnlyRepository;
        this.plan = plan;
    }

    public void addStep(DeploymentStep step) {
        this.addStep((Step)adapt.apply((Object)step));
    }

    public void addSteps(DeploymentStep ... steps) {
        this.addSteps(Iterables.transform((Iterable)Lists.newArrayList((Object[])steps), adapt));
    }

    public void addSteps(Collection<DeploymentStep> steps) {
        this.addSteps(Iterables.transform(steps, adapt));
    }

    public void addStep(Step step) {
        this.planningResult.add(step);
    }

    public void addSteps(Step ... steps) {
        this.planningResult.addAll(Lists.newArrayList((Object[])steps));
    }

    public void addSteps(Iterable<Step> steps) {
        this.planningResult.addAll(Lists.newArrayList(steps));
    }

    public void addCheckpoint(Step step, Delta delta) {
        this.plan.getCheckpoints().add(new Plan.Checkpoint(delta, step));
    }

    public void addCheckpoint(Step step, Delta delta, Operation overrideOperation) {
        if (delta.getOperation() != Operation.MODIFY) {
            Preconditions.checkArgument((delta.getOperation() == overrideOperation ? 1 : 0) != 0, (Object)String.format("The delta's operation (%s) and overrideOperation (%s) should match in non-modify scenarios", delta.getOperation(), overrideOperation));
        }
        this.plan.getCheckpoints().add(new Plan.Checkpoint(delta, step, overrideOperation));
    }

    public void addCheckpoint(Step step, Iterable<Delta> deltas) {
        for (Delta delta : deltas) {
            this.plan.getCheckpoints().add(new Plan.Checkpoint(delta, step));
        }
    }

    public void addStepWithCheckpoint(Step step, Delta delta) {
        this.addStep(step);
        this.addCheckpoint(step, delta);
    }

    public void addStepWithCheckpoint(Step step, Delta delta, Operation overrideOperation) {
        this.addStep(step);
        this.addCheckpoint(step, delta, overrideOperation);
    }

    public void addStepWithCheckpoint(Step step, Iterable<Delta> deltas) {
        this.addStep(step);
        this.addCheckpoint(step, deltas);
    }

    public Object getAttribute(String param) {
        return this.attributes.get(param);
    }

    public void setAttribute(String param, Object value) {
        this.attributes.put(param, value);
        if (value instanceof ExecutionStateListener) {
            this.plan.getListeners().add((ExecutionStateListener)value);
        }
    }

    public DeployedApplication getDeployedApplication() {
        return this.deployedApplication;
    }

    public ReadOnlyRepository getRepository() {
        return this.readOnlyRepository;
    }
}

