/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import javax.jcr.AccessDeniedException;
import javax.jcr.InvalidItemStateException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import org.apache.jackrabbit.core.ItemData;
import org.apache.jackrabbit.core.ItemImpl;
import org.apache.jackrabbit.core.ItemManager;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.PropertyImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.id.ItemId;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.id.PropertyId;
import org.apache.jackrabbit.core.nodetype.EffectiveNodeType;
import org.apache.jackrabbit.core.nodetype.NodeTypeConflictException;
import org.apache.jackrabbit.core.nodetype.NodeTypeImpl;
import org.apache.jackrabbit.core.nodetype.NodeTypeManagerImpl;
import org.apache.jackrabbit.core.nodetype.NodeTypeRegistry;
import org.apache.jackrabbit.core.security.AccessManager;
import org.apache.jackrabbit.core.session.SessionContext;
import org.apache.jackrabbit.core.session.SessionWriteOperation;
import org.apache.jackrabbit.core.state.ChildNodeEntry;
import org.apache.jackrabbit.core.state.ItemState;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.state.PropertyState;
import org.apache.jackrabbit.core.state.SessionItemStateManager;
import org.apache.jackrabbit.core.state.StaleItemStateException;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.core.version.InternalVersionManager;
import org.apache.jackrabbit.core.version.VersionHistoryInfo;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.spi.commons.nodetype.PropertyDefinitionImpl;
import org.apache.jackrabbit.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ItemSaveOperation
implements SessionWriteOperation<Object> {
    private static final Logger log = LoggerFactory.getLogger(ItemSaveOperation.class);
    private final ItemState state;

    public ItemSaveOperation(ItemState state) {
        this.state = state;
    }

    @Override
    public Object perform(SessionContext context) throws RepositoryException {
        Collection<ItemState> dirty;
        SessionItemStateManager stateMgr = context.getItemStateManager();
        try {
            dirty = this.getTransientStates(context.getItemStateManager());
        }
        catch (ConcurrentModificationException e) {
            String msg = "Concurrent modification; session is closed";
            log.error(msg, (Throwable)e);
            context.getSessionImpl().logout();
            throw e;
        }
        if (dirty.size() == 0) {
            return this;
        }
        Collection<ItemState> removed = this.getRemovedStates(context.getItemStateManager());
        HashMap<ItemId, ItemState> affected = new HashMap<ItemId, ItemState>(dirty.size() + removed.size());
        for (ItemState state : dirty) {
            affected.put(state.getId(), state);
        }
        for (ItemState state : removed) {
            affected.put(state.getId(), state);
        }
        for (ItemState transientState : affected.values()) {
            if (!transientState.isNode()) continue;
            NodeState nodeState = (NodeState)transientState;
            HashSet<NodeId> dependentIDs = new HashSet<NodeId>();
            if (nodeState.hasOverlayedState()) {
                NodeState overlayedState = (NodeState)nodeState.getOverlayedState();
                NodeId oldParentId = overlayedState.getParentId();
                NodeId newParentId = nodeState.getParentId();
                if (oldParentId != null) {
                    if (newParentId == null) {
                        if (overlayedState.isShareable()) {
                            dependentIDs.addAll(overlayedState.getSharedSet());
                        } else {
                            dependentIDs.add(oldParentId);
                        }
                    } else if (!oldParentId.equals(newParentId)) {
                        dependentIDs.add(oldParentId);
                        dependentIDs.add(newParentId);
                    } else if (!affected.containsKey(newParentId) && stateMgr.hasTransientItemState(newParentId)) {
                        try {
                            NodeState parent = (NodeState)stateMgr.getTransientItemState(newParentId);
                            for (ChildNodeEntry cne : parent.getRenamedChildNodeEntries()) {
                                if (!cne.getId().equals(nodeState.getId())) continue;
                                dependentIDs.add(newParentId);
                            }
                        }
                        catch (ItemStateException ise) {
                            log.warn("failed to retrieve transient state: " + newParentId, (Throwable)ise);
                        }
                    }
                }
            }
            for (ChildNodeEntry cne : nodeState.getRemovedChildNodeEntries()) {
                dependentIDs.add(cne.getId());
            }
            for (ChildNodeEntry cne : nodeState.getAddedChildNodeEntries()) {
                dependentIDs.add(cne.getId());
            }
            for (NodeId id : dependentIDs) {
                if (affected.containsKey(id) || !stateMgr.hasTransientItemState(id) && !stateMgr.hasTransientItemStateInAttic(id)) continue;
                String msg = context.getItemManager().safeGetJCRPath(id) + " needs to be saved as well.";
                log.debug(msg);
                throw new ConstraintViolationException(msg);
            }
        }
        this.validateTransientItems(context, dirty, removed);
        try {
            stateMgr.edit();
        }
        catch (IllegalStateException e) {
            throw new RepositoryException("Unable to start edit operation", (Throwable)e);
        }
        boolean succeeded = false;
        try {
            this.removeTransientItems(context.getItemStateManager(), removed);
            this.processShareableNodes(context.getRepositoryContext().getNodeTypeRegistry(), dirty);
            if (this.initVersionHistories(context, dirty)) {
                dirty = this.getTransientStates(context.getItemStateManager());
            }
            this.persistTransientItems(context.getItemManager(), dirty);
            for (ItemState transientState : dirty) {
                stateMgr.disposeTransientItemState(transientState);
            }
            stateMgr.update();
            succeeded = true;
        }
        catch (StaleItemStateException e) {
            throw new InvalidItemStateException("Unable to update a stale item: " + this, (Throwable)e);
        }
        catch (ItemStateException e) {
            throw new RepositoryException("Unable to update item: " + this, (Throwable)e);
        }
        finally {
            if (!succeeded) {
                stateMgr.cancel();
                this.restoreTransientItems(context, dirty);
            }
        }
        for (ItemState transientState : removed) {
            stateMgr.disposeTransientItemStateInAttic(transientState);
        }
        return this;
    }

    private Collection<ItemState> getTransientStates(SessionItemStateManager sism) throws InvalidItemStateException, RepositoryException {
        ArrayList<ItemState> dirty = new ArrayList<ItemState>();
        if (this.state.isNode()) {
            block11: for (ItemState transientState : sism.getDescendantTransientItemStates(this.state.getId())) {
                switch (transientState.getStatus()) {
                    case 2: 
                    case 4: {
                        dirty.add(transientState);
                        continue block11;
                    }
                    case 6: {
                        throw new InvalidItemStateException("Item cannot be saved because it has been deleted externally: " + this);
                    }
                    case 0: {
                        throw new InvalidItemStateException("Item cannot be saved; it seems to have been removed externally: " + this);
                    }
                }
                log.warn("Unexpected item state status: " + transientState.getStatus() + " of " + this);
            }
        }
        if (this.state.isTransient()) {
            switch (this.state.getStatus()) {
                case 2: {
                    dirty.add(this.state);
                    break;
                }
                case 4: {
                    throw new RepositoryException("Cannot save a new item: " + this);
                }
                case 6: {
                    throw new InvalidItemStateException("Item cannot be saved because it has been deleted externally:" + this);
                }
                case 0: {
                    throw new InvalidItemStateException("Item cannot be saved; it seems to have been removed externally: " + this);
                }
                default: {
                    log.warn("Unexpected item state status:" + this.state.getStatus() + " of " + this);
                }
            }
        }
        return dirty;
    }

    private Collection<ItemState> getRemovedStates(SessionItemStateManager sism) throws InvalidItemStateException, RepositoryException {
        if (this.state.isNode()) {
            ArrayList<ItemState> removed = new ArrayList<ItemState>();
            for (ItemState transientState : sism.getDescendantTransientItemStatesInAttic(this.state.getId())) {
                if (transientState.getStatus() == 6) {
                    throw new InvalidItemStateException("Item can't be removed because it has already been deleted externally: " + transientState.getId());
                }
                removed.add(transientState);
            }
            return removed;
        }
        return Collections.emptyList();
    }

    /*
     * Could not resolve type clashes
     */
    private void validateTransientItems(SessionContext context, Iterable<ItemState> dirty, Iterable<ItemState> removed) throws RepositoryException {
        String msg;
        Path path;
        Object def;
        SessionImpl session = context.getSessionImpl();
        ItemManager itemMgr = context.getItemManager();
        SessionItemStateManager stateMgr = context.getItemStateManager();
        AccessManager accessMgr = context.getAccessManager();
        NodeTypeManagerImpl ntMgr = context.getNodeTypeManager();
        for (ItemState itemState : dirty) {
            String[] constraints;
            def = itemState.isNode() ? itemMgr.getDefinition((NodeState)itemState) : itemMgr.getDefinition((PropertyState)itemState);
            if (!def.isProtected()) {
                path = stateMgr.getHierarchyMgr().getPath(itemState.getId());
                boolean isGranted = true;
                if (itemState.isNode()) {
                    if (itemState.getStatus() == 4) {
                        isGranted = accessMgr.isGranted(path, 4);
                    }
                } else {
                    isGranted = accessMgr.isGranted(path, 2);
                }
                if (!isGranted) {
                    msg = itemMgr.safeGetJCRPath(path) + ": not allowed to add or modify item";
                    log.debug(msg);
                    throw new AccessDeniedException(msg);
                }
            }
            if (itemState.isNode()) {
                String msg2;
                NodeState overlaid;
                boolean primaryTypeChanged;
                NodeState nodeState = (NodeState)itemState;
                NodeId id = nodeState.getNodeId();
                NodeDefinition nodeDef = (NodeDefinition)def;
                NodeTypeImpl pnt = ntMgr.getNodeType(nodeState.getNodeTypeName());
                EffectiveNodeType ent = this.getEffectiveNodeType(context.getRepositoryContext().getNodeTypeRegistry(), nodeState);
                boolean bl = primaryTypeChanged = nodeState.getStatus() == 4;
                if (!primaryTypeChanged && (overlaid = (NodeState)nodeState.getOverlayedState()) != null) {
                    Name oldName;
                    Name newName = nodeState.getNodeTypeName();
                    boolean bl2 = primaryTypeChanged = !newName.equals(oldName = overlaid.getNodeTypeName());
                }
                if (primaryTypeChanged) {
                    for (NodeType ntReq : nodeDef.getRequiredPrimaryTypes()) {
                        Name ntName = ((NodeTypeImpl)ntReq).getQName();
                        if (pnt.getQName().equals(ntName) || pnt.isDerivedFrom(ntName)) continue;
                        String msg3 = itemMgr.safeGetJCRPath(id) + " must be of node type " + ntReq.getName();
                        log.debug(msg3);
                        throw new ConstraintViolationException(msg3);
                    }
                }
                for (NodeType pd : ent.getMandatoryPropDefs()) {
                    if (pd.getDeclaringNodeType().equals(NameConstants.MIX_VERSIONABLE) || pd.getDeclaringNodeType().equals(NameConstants.MIX_SIMPLE_VERSIONABLE)) continue;
                    msg2 = itemMgr.safeGetJCRPath(id) + ": mandatory property " + pd.getName() + " does not exist";
                    if (!nodeState.hasPropertyName(pd.getName())) {
                        log.debug(msg2);
                        throw new ConstraintViolationException(msg2);
                    }
                    PropertyId pi = new PropertyId(nodeState.getNodeId(), pd.getName());
                    ItemData childData = itemMgr.getItemData(pi, null, false);
                    if (childData.getDefinition().isMandatory()) continue;
                    throw new ConstraintViolationException(msg2);
                }
                for (NodeType cnd : ent.getMandatoryNodeDefs()) {
                    msg2 = itemMgr.safeGetJCRPath(id) + ": mandatory child node " + cnd.getName() + " does not exist";
                    if (!nodeState.hasChildNodeEntry(cnd.getName())) {
                        log.debug(msg2);
                        throw new ConstraintViolationException(msg2);
                    }
                    boolean hasMandatoryChild = false;
                    for (ChildNodeEntry cne : nodeState.getChildNodeEntries(cnd.getName())) {
                        ItemData childData = itemMgr.getItemData(cne.getId(), null, false);
                        if (!childData.getDefinition().isMandatory()) continue;
                        hasMandatoryChild = true;
                        break;
                    }
                    if (hasMandatoryChild) continue;
                    throw new ConstraintViolationException(msg2);
                }
                continue;
            }
            PropertyState propState = (PropertyState)itemState;
            PropertyId propId = propState.getPropertyId();
            PropertyDefinitionImpl propDef = (PropertyDefinitionImpl)def;
            if (def.isProtected() || (constraints = propDef.getValueConstraints()) == null) continue;
            InternalValue[] values = propState.getValues();
            try {
                EffectiveNodeType.checkSetPropertyValueConstraints(propDef.unwrap(), values);
            }
            catch (RepositoryException e) {
                String msg4 = itemMgr.safeGetJCRPath(propId) + ": " + e.getMessage();
                log.debug(msg4);
                throw new ConstraintViolationException(msg4);
            }
            if (constraints.length <= 0 || propDef.getRequiredType() != 9 && propDef.getRequiredType() != 10) continue;
            for (InternalValue internalV : values) {
                boolean satisfied = false;
                String constraintViolationMsg = null;
                try {
                    NodeId targetId = internalV.getNodeId();
                    if (propDef.getRequiredType() == 10 && !itemMgr.itemExists(targetId)) continue;
                    NodeImpl targetNode = session.getNodeById(targetId);
                    for (String constrNtName : constraints) {
                        if (!targetNode.isNodeType(constrNtName)) continue;
                        satisfied = true;
                        break;
                    }
                    if (!satisfied) {
                        NodeType[] mixinNodeTypes = targetNode.getMixinNodeTypes();
                        String[] targetMixins = new String[mixinNodeTypes.length];
                        for (int j = 0; j < mixinNodeTypes.length; ++j) {
                            targetMixins[j] = mixinNodeTypes[j].getName();
                        }
                        String targetMixinsString = Text.implode((String[])targetMixins, (String)", ");
                        String constraintsString = Text.implode((String[])constraints, (String)", ");
                        constraintViolationMsg = itemMgr.safeGetJCRPath(propId) + ": is constraint to [" + constraintsString + "] but references [primaryType=" + targetNode.getPrimaryNodeType().getName() + ", mixins=" + targetMixinsString + "]";
                    }
                }
                catch (RepositoryException re) {
                    String msg5 = itemMgr.safeGetJCRPath(propId) + ": failed to check " + (propDef.getRequiredType() == 9 ? "REFERENCE" : "WEAKREFERENCE") + " value constraint";
                    log.debug(msg5);
                    throw new ConstraintViolationException(msg5, (Throwable)re);
                }
                if (satisfied) continue;
                log.debug(constraintViolationMsg);
                throw new ConstraintViolationException(constraintViolationMsg);
            }
        }
        for (ItemState itemState : removed) {
            int permission;
            try {
                def = itemState.isNode() ? itemMgr.getDefinition((NodeState)itemState).unwrap() : itemMgr.getDefinition((PropertyState)itemState).unwrap();
            }
            catch (ConstraintViolationException e) {
                continue;
            }
            if (def.isProtected() || accessMgr.isGranted(path = stateMgr.getAtticAwareHierarchyMgr().getPath(itemState.getId()), permission = itemState.isNode() ? 8 : 16)) continue;
            msg = itemMgr.safeGetJCRPath(path) + ": not allowed to remove item";
            log.debug(msg);
            throw new AccessDeniedException(msg);
        }
    }

    private void removeTransientItems(SessionItemStateManager sism, Iterable<ItemState> states) {
        for (ItemState transientState : states) {
            ItemState persistentState = transientState.getOverlayedState();
            sism.destroy(persistentState);
        }
    }

    private void processShareableNodes(NodeTypeRegistry registry, Iterable<ItemState> states) throws RepositoryException {
        for (ItemState is : states) {
            if (!is.isNode()) continue;
            NodeState ns = (NodeState)is;
            boolean wasShareable = false;
            if (ns.hasOverlayedState()) {
                NodeState old = (NodeState)ns.getOverlayedState();
                EffectiveNodeType ntOld = this.getEffectiveNodeType(registry, old);
                wasShareable = ntOld.includesNodeType(NameConstants.MIX_SHAREABLE);
            }
            EffectiveNodeType ntNew = this.getEffectiveNodeType(registry, ns);
            boolean isShareable = ntNew.includesNodeType(NameConstants.MIX_SHAREABLE);
            if (!wasShareable && isShareable) {
                ns.addShare(ns.getParentId());
                continue;
            }
            if (!wasShareable || isShareable) continue;
            String msg = "Removing mix:shareable is not supported.";
            log.debug(msg);
            throw new UnsupportedRepositoryOperationException(msg);
        }
    }

    private boolean initVersionHistories(SessionContext context, Iterable<ItemState> states) throws RepositoryException {
        SessionImpl session = context.getSessionImpl();
        ItemManager itemMgr = context.getItemManager();
        boolean createdTransientState = false;
        for (ItemState itemState : states) {
            if (!itemState.isNode()) continue;
            NodeState nodeState = (NodeState)itemState;
            EffectiveNodeType nt = this.getEffectiveNodeType(context.getRepositoryContext().getNodeTypeRegistry(), nodeState);
            if (nt.includesNodeType(NameConstants.MIX_VERSIONABLE)) {
                if (nodeState.hasPropertyName(NameConstants.JCR_VERSIONHISTORY)) continue;
                NodeImpl node = (NodeImpl)itemMgr.getItem(itemState.getId(), false);
                InternalVersionManager vMgr = session.getInternalVersionManager();
                VersionHistoryInfo history = vMgr.getVersionHistory((Session)session, nodeState, null);
                InternalValue historyId = InternalValue.create(history.getVersionHistoryId());
                InternalValue versionId = InternalValue.create(history.getRootVersionId());
                node.internalSetProperty(NameConstants.JCR_VERSIONHISTORY, historyId);
                node.internalSetProperty(NameConstants.JCR_BASEVERSION, versionId);
                node.internalSetProperty(NameConstants.JCR_ISCHECKEDOUT, InternalValue.create(true));
                node.internalSetProperty(NameConstants.JCR_PREDECESSORS, new InternalValue[]{versionId});
                createdTransientState = true;
                continue;
            }
            if (!nt.includesNodeType(NameConstants.MIX_SIMPLE_VERSIONABLE)) continue;
            InternalVersionManager vMgr = session.getInternalVersionManager();
            vMgr.getVersionHistory((Session)session, nodeState, null);
            NodeImpl node = (NodeImpl)itemMgr.getItem(itemState.getId(), false);
            if (nodeState.hasPropertyName(NameConstants.JCR_ISCHECKEDOUT)) continue;
            node.internalSetProperty(NameConstants.JCR_ISCHECKEDOUT, InternalValue.create(true));
            createdTransientState = true;
        }
        return createdTransientState;
    }

    private void persistTransientItems(ItemManager itemMgr, Iterable<ItemState> states) throws RepositoryException {
        for (ItemState state : states) {
            itemMgr.getItem(state.getId(), false).makePersistent();
        }
    }

    private void restoreTransientItems(SessionContext context, Iterable<ItemState> items) {
        ItemManager itemMgr = context.getItemManager();
        SessionItemStateManager stateMgr = context.getItemStateManager();
        for (ItemState itemState : items) {
            ItemId id = itemState.getId();
            try {
                ItemImpl item;
                if (stateMgr.isItemStateInAttic(id)) {
                    item = itemMgr.createItemInstance(itemState);
                    itemState.setStatus(4);
                } else {
                    try {
                        item = itemMgr.getItem(id, false);
                    }
                    catch (ItemNotFoundException infe) {
                        item = itemMgr.createItemInstance(itemState);
                        itemState.setStatus(4);
                    }
                }
                if (item.isNode()) {
                    NodeImpl node = (NodeImpl)item;
                    node.restoreTransient((NodeState)itemState);
                    continue;
                }
                PropertyImpl prop = (PropertyImpl)item;
                prop.restoreTransient((PropertyState)itemState);
            }
            catch (RepositoryException re) {
                String msg = itemMgr.safeGetJCRPath(id) + ": failed to restore transient state";
                log.warn(msg, (Throwable)re);
            }
        }
    }

    private EffectiveNodeType getEffectiveNodeType(NodeTypeRegistry registry, NodeState state) throws RepositoryException {
        try {
            return registry.getEffectiveNodeType(state.getNodeTypeName(), state.getMixinTypeNames());
        }
        catch (NodeTypeConflictException e) {
            throw new RepositoryException("Failed to build effective node type of node state " + state.getId(), (Throwable)e);
        }
    }

    public String toString() {
        return "item.save()";
    }
}

