/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.booter.local;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.xebialabs.deployit.booter.local.LocalDescriptor;
import com.xebialabs.deployit.booter.local.SyntheticHelper;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class LocalDescriptorRegistry
extends DescriptorRegistry {
    private final Map<Type, Descriptor> descriptors = Maps.newHashMap();
    private final Multimap<Type, Type> subtypes = HashMultimap.create();
    private static Logger logger = LoggerFactory.getLogger(LocalDescriptorRegistry.class);

    static void register(Class<? extends ConfigurationItem> ci) {
        Descriptor descriptor = LocalDescriptor.from(ci);
        logger.debug("Found ConfigurationItem: {}", (Object)descriptor);
        LocalDescriptorRegistry.register(descriptor);
    }

    static void register(Descriptor descriptor) {
        LocalDescriptorRegistry registry = (LocalDescriptorRegistry)LocalDescriptorRegistry.getInstance();
        Preconditions.checkState((!registry.descriptors.containsKey(descriptor.getType()) ? 1 : 0) != 0, (String)"The type [%s] is already registered in Deployit.", (Object[])new Object[]{descriptor.getType()});
        registry.descriptors.put(descriptor.getType(), descriptor);
    }

    static void registerSyntheticTypeDefinition(Element syntheticElement) {
        Descriptor descriptor = LocalDescriptor.from(syntheticElement);
        logger.debug("Found ConfigurationItem: {}", (Object)descriptor);
        LocalDescriptorRegistry.register(descriptor);
    }

    static void registerSyntheticTypeModification(Element typeModificationElement) {
        String typeName = SyntheticHelper.getRequiredStringAttribute(typeModificationElement, "type");
        LocalDescriptor d = (LocalDescriptor)LocalDescriptorRegistry.getDescriptor((String)typeName);
        d.parseTypeModification(typeModificationElement);
    }

    static void registerSubtype(Type supertype, Type subtype) {
        Preconditions.checkState((!supertype.equals((Object)subtype) ? 1 : 0) != 0, (String)"Cannot register [%s] as its own subtype.", (Object[])new Object[]{supertype});
        ((LocalDescriptorRegistry)LocalDescriptorRegistry.getInstance()).subtypes.put((Object)supertype, (Object)subtype);
    }

    protected Collection<Descriptor> _getDescriptors() {
        return Collections.unmodifiableCollection(this.descriptors.values());
    }

    protected Collection<Type> _getSubtypes(Type supertype) {
        return Collections.unmodifiableCollection(this.subtypes.get((Object)supertype));
    }

    protected Descriptor _getDescriptor(Type type) {
        Preconditions.checkState((!this.descriptors.isEmpty() ? 1 : 0) != 0, (Object)"DescriptorRegistry not booted");
        Preconditions.checkArgument((boolean)LocalDescriptorRegistry.exists((Type)type), (String)"Unknown type [%s]", (Object[])new Object[]{type});
        return this.descriptors.get(type);
    }

    protected boolean _exists(Type type) {
        return this.descriptors.containsKey(type);
    }
}

