/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.ssh;

import com.xebialabs.overthere.CmdLine;
import com.xebialabs.overthere.CmdLineArgument;
import com.xebialabs.overthere.ConnectionOptions;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.RuntimeIOException;
import com.xebialabs.overthere.spi.AddressPortMapper;
import com.xebialabs.overthere.ssh.SshScpConnection;
import com.xebialabs.overthere.ssh.SshSudoFile;
import java.text.MessageFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SshSudoConnection
extends SshScpConnection {
    public static final String NOSUDO_PSEUDO_COMMAND = "nosudo";
    protected final String sudoUsername;
    protected final String sudoCommandPrefix;
    protected final boolean sudoQuoteCommand;
    protected final boolean sudoPreserveAttributesOnCopyFromTempFile;
    protected final boolean sudoPreserveAttributesOnCopyToTempFile;
    protected final boolean sudoOverrideUmask;
    private Logger logger = LoggerFactory.getLogger(SshSudoFile.class);

    public SshSudoConnection(String type, ConnectionOptions options, AddressPortMapper mapper) {
        super(type, options, mapper);
        this.sudoUsername = (String)options.get("sudoUsername");
        this.sudoCommandPrefix = options.get("sudoCommandPrefix", "sudo -u {0}");
        this.sudoQuoteCommand = options.getBoolean("sudoQuoteCommand", false);
        this.sudoPreserveAttributesOnCopyFromTempFile = options.getBoolean("sudoPreserveAttributesOnCopyFromTempFile", true);
        this.sudoPreserveAttributesOnCopyToTempFile = options.getBoolean("sudoPreserveAttributesOnCopyToTempFile", true);
        this.sudoOverrideUmask = options.get("sudoOverrideUmask", true);
    }

    @Override
    protected CmdLine processCommandLine(CmdLine commandLine) {
        CmdLine cmd;
        if (this.startsWithPseudoCommand(commandLine, NOSUDO_PSEUDO_COMMAND)) {
            this.logger.trace("Not prefixing command line with sudo statement because the nosudo pseudo command was present, but the pseudo command will be stripped");
            this.logger.trace("Replacing: {}", (Object)commandLine);
            cmd = SshSudoConnection.stripPrefixedPseudoCommand(commandLine);
            this.logger.trace("With     : {}", (Object)cmd);
        } else {
            this.logger.trace("Prefixing command line with sudo statement");
            this.logger.trace("Replacing: {}", (Object)commandLine);
            boolean nocd = this.startsWithPseudoCommand(commandLine, "nocd");
            cmd = nocd ? SshSudoConnection.stripPrefixedPseudoCommand(commandLine) : commandLine;
            cmd = this.prefixWithSudoCommand(cmd);
            if (nocd) {
                cmd = SshSudoConnection.prefixWithPseudoCommand(cmd, "nocd");
            }
            this.logger.trace("With     : {}", (Object)cmd);
        }
        return super.processCommandLine(cmd);
    }

    CmdLine prefixWithSudoCommand(CmdLine commandLine) {
        CmdLine commandLineWithSudo = new CmdLine();
        this.addSudoStatement(commandLineWithSudo);
        if (this.sudoQuoteCommand) {
            commandLineWithSudo.addNested(commandLine);
        } else {
            for (CmdLineArgument a : commandLine.getArguments()) {
                commandLineWithSudo.add(a);
                if (!a.toString(this.os, false).equals("|") && !a.toString(this.os, false).equals(";")) continue;
                this.addSudoStatement(commandLineWithSudo);
            }
        }
        return commandLineWithSudo;
    }

    private void addSudoStatement(CmdLine sudoCommandLine) {
        String prefix = MessageFormat.format(this.sudoCommandPrefix, this.sudoUsername);
        for (String arg : prefix.split("\\s+")) {
            sudoCommandLine.addArgument(arg);
        }
    }

    @Override
    protected OverthereFile getFile(String hostPath, boolean isTempFile) throws RuntimeIOException {
        return new SshSudoFile(this, hostPath, isTempFile);
    }

    @Override
    public String toString() {
        return "ssh:" + this.sshConnectionType.toString().toLowerCase() + "://" + this.username + ":" + this.sudoUsername + "@" + this.host + ":" + this.port;
    }
}

