/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.deployment.planner;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.engine.spi.execution.ExecutionStateListener;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.flow.Step;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.util.List;

public class Plan {
    private List<Step> steps = Lists.newArrayList();
    private List<Checkpoint> checkpoints = Lists.newArrayList();
    private List<ExecutionStateListener> listeners = Lists.newArrayList();

    public List<Step> getSteps() {
        return this.steps;
    }

    public List<Checkpoint> getCheckpoints() {
        return this.checkpoints;
    }

    public List<ExecutionStateListener> getListeners() {
        return this.listeners;
    }

    public Writer writePlan(Writer writer) {
        PrintWriter out = new PrintWriter(writer);
        ArrayListMultimap checkpointsByStep = ArrayListMultimap.create();
        for (Checkpoint checkpoint : this.checkpoints) {
            checkpointsByStep.put((Object)checkpoint.getStep(), (Object)checkpoint);
        }
        int index = 0;
        for (Step step : this.steps) {
            out.format("%2s. (%3s) - %s  (%s)\n", ++index, step.getOrder(), step.getDescription(), step.getClass().getSimpleName());
            if (!checkpointsByStep.containsKey((Object)step)) continue;
            for (Checkpoint checkpoint : checkpointsByStep.get((Object)step)) {
                out.format("            *checkpoint*  %s\n", checkpoint);
            }
        }
        return writer;
    }

    public static class Checkpoint
    implements Serializable {
        private Delta delta;
        private Operation operation;
        private Step step;

        public Checkpoint(Delta delta, Step step) {
            this(delta, step, delta.getOperation());
        }

        public Checkpoint(Delta delta, Step step, Operation operation) {
            this.delta = delta;
            this.step = step;
            this.operation = operation;
        }

        public Delta getDelta() {
            return this.delta;
        }

        public Step getStep() {
            return this.step;
        }

        public Operation getOperation() {
            return this.operation;
        }

        public String toString() {
            switch (this.operation) {
                case CREATE: {
                    return String.format("%s %s", this.operation, this.delta.getDeployed());
                }
                case MODIFY: {
                    return String.format("%s from %s to %s", this.operation, this.delta.getPrevious(), this.delta.getDeployed());
                }
                case DESTROY: {
                    return String.format("%s %s", this.operation, this.delta.getPrevious());
                }
            }
            return this.operation.toString();
        }
    }
}

